#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Нагрузочное тестирование unified agent на стедже backend-services.

=head1 USAGE

./t/bin/unified_agent_load_test.pl --split 10

=head1 OPTIONS

    split - количество потоков
    topic - имя топика для записи

=cut

use lib::abs qw(
  ../../lib
  );

use qbit;

use Utils::ScriptWrapper 'util';
use Utils::Logger qw/ INFO/;

# Формируем пейлоад большого размера
my $data = [];
foreach my $i (1 .. 5000) {
    my $h = {};
    foreach my $letter ('a' .. 'z') {
        $h->{$letter} = $letter x 100;
    }
    push(@$data, $h);
}

open(FH, '>', 'payload.json') or die $!;
print FH to_json($data);
close(FH);

my $payload_size = [split(/\s+/, `du -h payload.json`)]->[0];
INFO("Prepared payload of size $payload_size");
`rm payload.json -f`;

run(
    sub {
        my ($app, $opts) = @_;

        $app->api_selfservice->logbroker(
            append_time_name => 'timestamp',
            data             => $data,
            topic            => $opts->{topic} // "partner.test.bk_page_update"
        );
    }
   );

sub key_data_for_split {
    my ($opts) = @_;
    return 'thread_ids';
}

sub prepare_args {
    my ($opts) = @_;

    if ($opts->{split}) {
        $opts->{thread_ids} = [map {$_} 1 .. $opts->{split}];
    }
}
