#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use PiConstants qw( $ADINSIDE_USER_ID  $ADINSIDE_CLIENT_ID  $SITE_PARTNER_ROLE_ID );

use Test::Partner2::Simple;

use Test::More;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(mock_curdate restore_table add_bookmaker_filter get_new_user set_test_partner_utils_app);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        set_test_partner_utils_app($app);

        mock_curdate('2014-03-01 00:00:00');
        mock_utils_partner2($app);

        get_new_user(
            users_add_opts => {id => $ADINSIDE_USER_ID, client_id => $ADINSIDE_CLIENT_ID},
            role_id        => $SITE_PARTNER_ROLE_ID
        );
        get_new_user(role_id => 2, cur_user => TRUE);

        my $dbh = $app->partner_db->get_dbh();

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        restore_table($dbh, $table_dumps_dir, 'tns_dict_article');
        restore_table($dbh, $table_dumps_dir, 'bk_language');

        my $PAGE_ID = 999;

        $app->api_bk;
        $app->{'api_bk'} = Test::MockObject::Extends->new($app->{api_bk});
        $app->api_bk->mock(
            'create_or_update_campaign',
            sub {
                my ($self, @other) = @_;
                if ($other[0]->{page_id}) {
                    return $other[0]->{page_id};
                } else {
                    $PAGE_ID++;
                    return $PAGE_ID;
                }
            }
        );

        $app->api_balance;
        $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});
        $app->api_balance->set_always('create_or_update_place', TRUE);

        $app->api_http_gozora;
        $app->{'api_http_gozora'} = Test::MockObject::Extends->new($app->{'api_http_gozora'});
        $app->api_http_gozora->set_always('get_page_inf', {body_length_bytes => 1});

        $app->internal_context_on_site_campaign;
        $app->{'internal_context_on_site_campaign'} =
          Test::MockObject::Extends->new($app->{'internal_context_on_site_campaign'});
        $app->internal_context_on_site_campaign->set_always('hook_post_validation', TRUE);

        my $default_quality_coef = 80;
        $dbh->do('DELETE FROM quality_def_coef');
        $app->partner_db->quality_def_coef->add({k => $default_quality_coef, dt => curdate(oformat => 'db')});

        add_bookmaker_filter($app);

        my $campaign_id = $app->internal_context_on_site_campaign->add(domain => "yandex.ru");
        $app->internal_context_on_site_campaign->do_action($campaign_id, 'register_in_balance');

        $app->partner_db->pagesbs->add(
            {
                page_id              => $campaign_id,
                domain               => "ya.ru",
                excludeddomains      => '',
                mirrors              => 'yandex.by,yandex.com,yandex.net',
                nopicturedomains     => 0,
                opt_dontshowbehavior => 0,
                opt_dontshowsex      => 0,
                opt_readonly         => 0,
                partner              => 0,
                srch_lang            => '',
                state                => 1,
                target_type          => '',
            }
        );
        my @mirrors = ("yandex.kz", "yandex.lt", @{$app->internal_context_on_site_campaign->mirrors->get_all()},);
        $app->internal_context_on_site_campaign->do_action($campaign_id, 'edit', mirrors => \@mirrors);

        my $context_diff = $app->devel_bk_pi_comparison->get_diff(
            type                 => 'context',
            state                => TRUE,
            domain               => TRUE,
            opt_readonly         => TRUE,
            opt_dontshowsex      => TRUE,
            opt_dontshowbehavior => TRUE,
            mirrors              => TRUE,
            excludeddomains      => TRUE,
        );

        my @diff_1000 = (
            {
                'bk'      => 'domain: ya.ru',
                'page_id' => '1000',
                'pi'      => 'domain: yandex.ru'
            },
            {
                'bk'      => 'excludeddomains: ',
                'page_id' => '1000',
                'pi'      => 'excludeddomains: yandex.kz yandex.lt yandex.ru'
            },
            {
                'bk'      => 'mirrors: yandex.by yandex.com yandex.net',
                'page_id' => '1000',
                'pi'      => 'mirrors: yandex.kz yandex.lt'
            }
        );

        is_deeply($context_diff, \@diff_1000, 'get_diff()',);

        $campaign_id = $app->internal_context_on_site_campaign->add(domain => "yandex.ru");
        $app->internal_context_on_site_campaign->do_action($campaign_id, 'register_in_balance');

        $context_diff = $app->devel_bk_pi_comparison->get_diff(
            type                 => 'context',
            state                => TRUE,
            domain               => TRUE,
            opt_readonly         => TRUE,
            opt_dontshowsex      => TRUE,
            opt_dontshowbehavior => TRUE,
            mirrors              => TRUE,
            excludeddomains      => TRUE,
        );

        is_deeply(
            $context_diff,
            [
                @diff_1000,
                {
                    'bk'      => 'domain: ',
                    'page_id' => '1001',
                    'pi'      => 'domain: yandex.ru'
                },
                {
                    'bk'      => 'excludeddomains: ',
                    'page_id' => '1001',
                    'pi'      => 'excludeddomains: yandex.ru'
                },
                {
                    'bk'      => 'opt_dontshowbehavior: ',
                    'page_id' => '1001',
                    'pi'      => 'opt_dontshowbehavior: 0'
                },
                {
                    'bk'      => 'opt_dontshowsex: ',
                    'page_id' => '1001',
                    'pi'      => 'opt_dontshowsex: 0'
                },
                {
                    'bk'      => 'opt_readonly: ',
                    'page_id' => '1001',
                    'pi'      => 'opt_readonly: 0'
                },
                {
                    'bk'      => 'page_id: ',
                    'page_id' => '1001',
                    'pi'      => 'page_id: 1001'
                },
                {
                    'bk'      => 'state: ',
                    'page_id' => '1001',
                    'pi'      => 'state: 1'
                },
            ],
            'get_diff() - no data in bk',
        );
    },
    locale         => 'en',
    fill_databases => 0,
);
