#!/usr/bin/perl

=encoding UTF-8

=head1 Описание

Тест проверяет что все gettext() строки в партнерском интерфейсе не состоят из
русских символов.

=cut

use qbit;
use Test::More tests => 1;
use Test::Utils;
use FindBin qw($Bin);
use lib::abs;
use String::ShellQuote;

my $qbit_xgettext = shell_quote(lib::abs::path('../bin/qbit_xgettext'));
my $lib           = shell_quote(lib::abs::path('../lib'));
my $templates     = shell_quote(lib::abs::path('../templates'));

my $output =
`perl $qbit_xgettext --dir $lib --dir $templates --file_ignore_re=lib\/qbit\/GetText\.pm --file_ignore_re=lib\/QBit\/WebInterface\/Controller\.pm`;

my @msgids_in_po = Test::Utils::get_all_msgids_from_po($output);

my $msgids_with_cyrillic = '';

foreach (@msgids_in_po) {

    next if /^Genitive, for example: Иванова Ивана Ивановича$/;
    next if /^Genitive, for example: генерального директора$/;
    next if /^ОАО$/;
    next if /^ИП$/;
    next if /^ООО$/;
    next if /^ЗАО$/;

    $msgids_with_cyrillic .= "$_\n" if /[а-я]/i;
}

is($msgids_with_cyrillic, '', 'All msgids have no russian symbols');
