use strict;
use warnings FATAL => 'all';

use Test::More;
use File::Find;
use qbit;
use lib::abs;
use Test::Partner2::Simple qw(need_self_update);

my $prefix         = '../../';
my $path_to_remove = lib::abs::path($prefix);

sub process {
    return if !defined($File::Find::fullname) || $File::Find::fullname !~ /\.json$/;

    my $content = readfile $File::Find::fullname;

    my $pretty_json = eval {to_json(from_json($content), pretty => 1)};
    if ($@) {
        fail sprintf('"%s" has valid json', $File::Find::fullname);
    }

    my $message = $File::Find::fullname;
    $message =~ s(^$path_to_remove/)();
    $message = 'JSON file is pretty printed - ' . $message;

    my $result = $content eq $pretty_json;

    if (!$result && need_self_update()) {
        writefile($File::Find::fullname, $pretty_json);

        $content = $pretty_json;
    }

    ok($result, $message);
}

sub main_in_test {

    # ./prove2 -v  $F  :: configs/
    my @paths =
        @ARGV > 0
      ? @ARGV
      : qw(
      api/
      bin/
      configs/
      dictionaries/
      lib/
      mysql_diff/
      resources/
      t/
      t_external/
      t_lib/
      t_old_test_data/
      );
    find(
        {
            wanted   => \&process,
            follow   => 1,
            no_chdir => 0,
        },
        map {lib::abs::path($prefix . $_)} @paths
    );

    done_testing();
}
main_in_test();
