use strict;
use warnings FATAL => 'all';
use Test::More;
use lib::abs;
use File::Slurp;
use Test::Differences;

use lib::abs qw(
  ../lib
  );
use Partner2::Code;

our @EXPECTED_SUB_ORDER = get_expected_sub_order();

my %EXPECTED_SUB = map {$_ => 1} grep {!ref($_)} @EXPECTED_SUB_ORDER;
my %EXPECTED_SUB_WITH_REGEX = map {$_ => 1} grep {ref($_) eq 'Regexp'} @EXPECTED_SUB_ORDER;

our %TMP_SUBS_WITH_ASTERISK = (
    # /regex/ => [ 'sub1', ... ]
);

sub sub_should_have_order {
    my ($sub) = @_;

    my $result = 0;

    if ($EXPECTED_SUB{$sub}) {
        $result = 1;
    } else {
        foreach my $regex (keys %EXPECTED_SUB_WITH_REGEX) {
            if ($sub =~ /$regex/) {
                $result = 1;
                push @{$TMP_SUBS_WITH_ASTERISK{$regex}}, $sub;
                last;
            }
        }
    }

    return $result;
}

sub check_order_in_file {
    my ($file_name) = @_;

    my @lines = read_file(
        $file_name,
        {
            binmode => ':utf8',
            chomp   => 1,
        },
    );

    my @subs_in_file = map {/sub ([^\s]+)/} grep {/^sub /} @lines;
    my %subs_in_file = map {$_ => 1} @subs_in_file;

    my $text_with_current_sub_order  = '';
    my $text_with_expected_sub_order = '';

    %TMP_SUBS_WITH_ASTERISK = ();

    foreach my $sub (@subs_in_file) {
        if (sub_should_have_order($sub)) {
            $text_with_current_sub_order .= 'sub ' . $sub . "\n";
        }
    }

    ### order regex subs
    my $regex_subs_to_order = get_regex_subs_to_order();
    foreach my $regex (keys %TMP_SUBS_WITH_ASTERISK) {
        my $subs          = $TMP_SUBS_WITH_ASTERISK{$regex};
        my @filtered_subs = grep {!$EXPECTED_SUB{$_}} @$subs;
        my $ordered_subs  = $regex_subs_to_order->{$regex}->(\@filtered_subs);
        $TMP_SUBS_WITH_ASTERISK{$regex} = $ordered_subs;
    }

    foreach my $sub (@EXPECTED_SUB_ORDER) {
        if ($subs_in_file{$sub}) {
            $text_with_expected_sub_order .= 'sub ' . $sub . "\n";
        } elsif (ref($sub) eq 'Regexp') {
            foreach my $tmp_sub (@{$TMP_SUBS_WITH_ASTERISK{$sub}}) {
                if ($tmp_sub =~ /$sub/) {
                    $text_with_expected_sub_order .= 'sub ' . $tmp_sub . "\n";
                }
            }
        }
    }

    eq_or_diff $text_with_current_sub_order, $text_with_expected_sub_order, $file_name;

    return 1;
}

sub main_in_test {
    pass('Loaded ok');

    if ($ARGV[0]) {
        check_order_in_file($ARGV[0]);
    } else {
        foreach my $file_name (get_pm_files()) {
            check_order_in_file($file_name);
        }
    }

    done_testing();
}
main_in_test();
