#!/usr/bin/perl -w

use qbit;

use lib::abs qw();
use Test::More;

_run();

sub _run {
    my $project_root = lib::abs::path('../../');

    my @configs = grep {-f} glob "$project_root/configs/*/Application.json";

    foreach my $path (sort @configs) {
        (my $relative_path = $path) =~ s|$project_root||;

        my $file = readfile($path);
        my $data = from_json($file);

        my $subtest = sprintf 'Config "%s"', $relative_path;
        subtest(
            $subtest => sub {
                foreach my $key (sort keys %$data) {
                    if (ref($data->{$key}) eq 'HASH' && exists $data->{$key}->{url}) {
                        foreach my $opt (qw(timeout attempts delay)) {
                            ok(exists $data->{$key}->{$opt},
                                sprintf('"%s" has "%s" option in "%s"', $key, $opt, $relative_path))
                              || last;
                        }
                    }
                }
            }
        );
    }
    done_testing();
}
