
=encoding UTF-8

=cut

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use qbit;
use Test::More tests => 9;
use Test::Deep qw(cmp_deeply);
use Test::Partner2::Mock;

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);
        mock_mailer($app);
        mock_utils_partner2($app);

        check_there_is_no_reload_timeout_in_get_add_fields($app);
        check_model_dies_if_unknown_paramter_is_passed_to_add($app);
        check_reload_timeout_in_add_and_edit($app);

    },
);

sub check_there_is_no_reload_timeout_in_get_add_fields {
    my ($app) = @_;

    my $data = $app->context_on_site_campaign->get_add_fields();
    ok(!$data->{reload_timeout}, 'no reload_timeout is in get_add_fields()');

    return 1;
}

sub check_model_dies_if_unknown_paramter_is_passed_to_add {
    my ($app) = @_;

    eval {
        $app->context_on_site_campaign->add(
            'block_title'   => 'block_title',
            'caption'       => 'caption',
            'domain_id'     => 2,
            'login'         => 'mocked-yan-partner',
            'no_such_param' => 44,
        );
    };

    is(
        $@->message(),
        "You can't use following fields in add: no_such_param",
        'add() does not work with unknown params',
      );

    return 1;
}

sub check_reload_timeout_in_add_and_edit {
    my ($app) = @_;

    my $default_value_for_reload_timeout = 30;
    my $custom_value_for_reload_timeout  = 12;

    note('context_on_site_campaign->add(...)');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my %edit_page_options = _get_edit_page_options($data->{0}{'Options'});

        is(
            $edit_page_options{'ReloadTimeout'},
            $default_value_for_reload_timeout,
            'Sending expected ReloadTimeout to EditPage parameter Options'
          );
    };

    my $ids = $app->context_on_site_campaign->add(
        'block_title' => 'block_title',
        'caption'     => 'caption',
        'domain_id'   => 2,
        'login'       => 'mocked-yan-partner',
    );

    my $data =
      $app->context_on_site_campaign->get($ids, fields => [qw(page_id reload_timeout available_fields editable_fields)],
      );

    is($data->{reload_timeout} => $default_value_for_reload_timeout, 'get() returns reload_timeout');
    is($data->{'available_fields'}{'reload_timeout'}, 1, 'get() returns reload_timeout in available_fields');
    is($data->{'editable_fields'}{'reload_timeout'},  1, 'get() returns reload_timeout in editable_fields');

    note('context_on_site_campaign->do_action($id, "edit", ...)');
    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data) = @_;

        my %edit_page_options = _get_edit_page_options($data->{0}{'Options'});

        is(
            $edit_page_options{'ReloadTimeout'},
            $custom_value_for_reload_timeout,
            'Sending expected ReloadTimeout to EditPage parameter Options'
          );
    };
    $app->context_on_site_campaign->do_action($ids, 'edit', reload_timeout => $custom_value_for_reload_timeout,);
    $app->context_on_site_campaign->update_in_bk({page_id => $data->{page_id}});
    my $data_2 = $app->context_on_site_campaign->get($ids, fields => [qw(reload_timeout)],);

    is($data_2->{reload_timeout} => $custom_value_for_reload_timeout, 'get() returns reload_timeout');

    return 1;
}

=begin comment _get_edit_page_options

    my %options = _get_edit_page_options('BlockTitle=SomeText;ReloadTimeout=12');

После этого в %options будет:

    {
        BlockTitle => 'SomeText',
        ReloadTimeout => 4,
    }

=end comment

=cut

sub _get_edit_page_options {
    my ($options) = @_;

    my %edit_page_options;

    foreach my $element (split(/;/, $options)) {
        my ($key, $value) = split(/=/, $element);
        $edit_page_options{$key} = $value;
    }

    return %edit_page_options;
}
