use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::MockObject::Extends;
use Test::Partner2::Mock;
use qbit;

use Test::More tests => 17;
use Test::Deep qw(cmp_deeply);
use PiConstants qw($BOOL_OBJECT);

our %COMMON = (
    campaign_id => 142898,

    border_color  => undef,
    border_radius => undef,
    border_type   => 'none',
    caption       => 'caption',
    favicon       => 1,
    font_family   => undef,
    font_size     => undef,
    hover_color   => 'AABBCC',

    limit                => 2,
    links_underline      => 1,
    no_sitelinks         => 1,
    site_bg_color        => 'AABBCC',
    sitelinks_color      => undef,
    text_color           => 'AABBCC',
    title_color          => 'AABBCC',
    title_font_size      => undef,
    type                 => '240x400',
    url_background_color => undef,
    url_color            => 'AABBCC',
    adaptive_height      => '',
    adaptive_width       => '',
);

sub cant_create_direct_block_with_incorrect_images_first {
    my ($app) = @_;

    eval {my $ids = $app->context_on_site_direct->add(%COMMON, images_first => 4,);};

    ok($@, "Can't create context_on_site_direct with incorect images_first");

    return 1;
}

sub can_create_direct_block_correct_images_first_1 {
    my ($app) = @_;

    my $ids = $app->context_on_site_direct->_split_id($app->context_on_site_direct->add(%COMMON, images_first => 1,));

    cmp_deeply(
        $ids,
        {
            campaign_id => 142898,
            id          => 3,
        },
        'Created direct block 3 for Page ID 142898',
    );

    my $data = $app->context_on_site_direct->get_all(
        filter => $ids,
        fields => [qw(images_first)],
    );

    cmp_deeply($data, [{'images_first' => '1'}], 'Got correct value from database (images_first = 1)',);

    $app->context_on_site_campaign->do_action(142898, 'register_in_balance');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data)             = @_;
        my $json_without_curly = $data->{0}->{DirectBlocks}->{3}->{Design};
        my $design             = $json_without_curly->{0}{design};
        is(ref($design->{imagesFirst}), $BOOL_OBJECT, 'Sending boolean imagesFirst to EditPage');
        ok($design->{imagesFirst}, 'Sending imagesFirst = true to EditPage');
    };

    $app->context_on_site_campaign->do_action(142898, 'start');
    $app->context_on_site_campaign->update_in_bk({page_id => $COMMON{campaign_id}});

    return 1;
}

sub can_create_direct_block_correct_images_first_0 {
    my ($app) = @_;

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data)             = @_;
        my $json_without_curly = $data->{0}->{DirectBlocks}->{4}->{Design};
        my $design             = $json_without_curly->{0}{design};
        is(ref($design->{imagesFirst}), $BOOL_OBJECT, 'Sending boolean imagesFirst to EditPage');
        ok(!$design->{imagesFirst}, 'Sending imagesFirst = false to EditPage');
    };

    my $ids = $app->context_on_site_direct->_split_id($app->context_on_site_direct->add(%COMMON, images_first => 0,));
    $app->context_on_site_campaign->update_in_bk({page_id => $COMMON{campaign_id}});

    cmp_deeply(
        $ids,
        {
            campaign_id => 142898,
            id          => 4,
        },
        'Created RTB block 4 for Page ID 142898',
    );

    my $data = $app->context_on_site_direct->get_all(
        filter => $ids,
        fields => [qw(images_first)],
    );

    cmp_deeply($data, [{'images_first' => '0'}], 'Got correct value from database (images_first = 0)',);

    return 1;
}

sub check_direct_block_edit_images_first {
    my ($app) = @_;

    my $before = $app->context_on_site_direct->get_all(
        filter => {campaign_id => 142898, id => 3},
        fields => [qw(available_fields editable_fields images_first)],
    );

    ok($before->[0]{available_fields}{images_first}, 'images_first are in available_fields');
    ok($before->[0]{editable_fields}{images_first},  'images_first are in editable_fields');
    is($before->[0]{images_first}, 1, 'At first images_first = 1');

    $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
        my ($data)             = @_;
        my $json_without_curly = $data->{0}->{DirectBlocks}->{3}->{Design};
        my $design             = $json_without_curly->{0}{design};
        is(ref($design->{imagesFirst}), $BOOL_OBJECT, 'Sending boolean imagesFirst to EditPage');
        ok(!$design->{imagesFirst}, 'Sending imagesFirst = false to EditPage');
    };

    $app->context_on_site_direct->do_action('D-A-142898-3', 'edit', images_first => 0,);
    $app->context_on_site_campaign->update_in_bk({page_id => $COMMON{campaign_id}});

    my $after = $app->context_on_site_direct->get_all(
        filter => {campaign_id => 142898, id => 3},
        fields => [qw(available_fields editable_fields images_first)],
    );

    is($after->[0]{images_first}, 0, 'After change images_first = 0');

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_agreement_checker($app);
        mock_bk($app);
        mock_balance($app);
        mock_format_system($app);

        cant_create_direct_block_with_incorrect_images_first($app);
        can_create_direct_block_correct_images_first_1($app);
        can_create_direct_block_correct_images_first_0($app);
        check_direct_block_edit_images_first($app);

        return 1;
    },
);
__END__
