#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::MockObject::Extends;
use Test::Partner::Utils qw(mock_curdate);

use qbit;

my $DATE = '2016-05-01';

my $CHECK_AFTER_CRON = {
    'adv_net_mobile' => {
        'regular_update_statistics_for_month' => sub {
            my ($app, $group, $method) = @_;

            cmp_deeply(
                $app->partner_db->statistics_mobile_app_rtb->get_all(filter => {dt => $DATE}),
                [
                    {
                        'mobile_rtb_bad_win_partner_price_w_nds'  => '20108328000',
                        'mobile_rtb_bad_win_partner_price_wo_nds' => '16756940000',
                        'mobile_rtb_bad_win_price_w_nds'          => '24522360000',
                        'mobile_rtb_partner_wo_nds'               => '300000000',
                        'mobile_rtb_partner_w_nds'                => '354000000',
                        'block_id'                                => '1',
                        'tag_id'                                  => '0',
                        'mobile_rtb_block_bad_win_hits'           => '5',
                        'mobile_rtb_block_bad_shows'              => '3',
                        'bad_win_partner_price_wo_nds'            => '16756940000',
                        'bad_win_partner_price_w_nds'             => '20108328000',
                        'mobile_rtb_block_shows'                  => '43',
                        'all_w_nds'                               => '354000000',
                        'mobile_rtb_block_bad_win_hits_unsold'    => '0',
                        'partner_wo_nds'                          => '300000000',
                        'mobile_rtb_block_bad_shows_own_adv'      => '0',
                        'bad_win_price_wo_nds'                    => '20435300000',
                        'mobile_rtb_block_bad_win_hits_own_adv'   => '0',
                        'mobile_rtb_block_shows_own_adv'          => '0',
                        'mobile_rtb_block_hits_unsold'            => '0',
                        'dt'                                      => '2016-05-01',
                        'mobile_rtb_all_w_nds'                    => '354000000',
                        'all_wo_nds'                              => '300000000',
                        'bad_win_price_w_nds'                     => '24522360000',
                        'mobile_rtb_bad_win_price_wo_nds'         => '20435300000',
                        'currency_id'                             => '2',
                        'mobile_rtb_block_hits'                   => '56',
                        'dsp_id'                                  => '1',
                        'mobile_rtb_block_direct_clicks'          => '10',
                        'mobile_rtb_block_direct_shows'           => '14',
                        'context_page_id'                         => '43569',
                        'mobile_rtb_block_hits_own_adv'           => '0',
                        'mobile_rtb_all_wo_nds'                   => '300000000',
                        'partner_w_nds'                           => '354000000'
                    }
                ],
                "$group -> $method statistics_mobile_app_rtb"
            );

            cmp_deeply(
                $app->partner_db->statistics_mobile_app_page->get_all(filter => {dt => $DATE}),
                [
                    {
                        'context_page_id'                 => '43569',
                        'dt'                              => '2016-05-01',
                        'an_mobile_rtb_cover_senthits'    => '3',
                        'an_mobile_rtb_cover_hits'        => '24',
                        'an_mobile_rtb_cover_direct_hits' => '50'
                    }
                ],
                "$group -> $method statistics_mobile_app_page"
            );
          }
    },
};

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        my $cron_data = $app->get_cron_methods();

        foreach my $group (sort(keys(%$cron_data))) {
            unless (exists($CHECK_AFTER_CRON->{$group})) {
                note("No test for $group");
                next;
            }

            foreach my $method (sort(keys(%{$cron_data->{$group}}))) {
                unless (exists($CHECK_AFTER_CRON->{$group}{$method})) {
                    note("No test for $group -> $method");
                    next;
                }

                $app->do($group, $method);
                $CHECK_AFTER_CRON->{$group}{$method}($app, $group, $method);
            }
        }
    },
    application_package => 'Cron'
);

sub mock_app {
    my ($app) = @_;

    mock_curdate('2016-05-04 12:29:17');

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});
    $app->api_balance->mock(
        'get_dsp_stat',
        sub {
            my ($api_balance, %opts) = @_;

            my @headers =
              qw(PAGE_ID BLOCK_ID DSP_ID DT HITS DSP DSPWITHOUTNDS PARTNER PARTNERWITHOUTNDS SHOWS AGGREGATORWITHOUTNDS AGGREGATOR TOTAL_RESPONSE_COUNT TOTAL_BID_SUM CLIENT_ID PARTNER_STAT_ID);

            my $tsv = join("\t", @headers) . "\n";

            if ($opts{'to'} eq $DATE) {
                my $struct = [
                    {
                        DT                => '2016-05-01 23:34:05',
                        PAGE_ID           => 43569,
                        BLOCK_ID          => 1,
                        DSP_ID            => 1,
                        SHOWS             => 43,
                        HITS              => 56,
                        DSP               => 0.0354,
                        DSPWITHOUTNDS     => 0.03,
                        PARTNER           => 0.0354,
                        PARTNERWITHOUTNDS => 0.03,
                        PARTNER_STAT_ID   => 0,
                    }
                ];
                if ($opts{'_get_tsv_fh'}) {
                    foreach my $entry (@$struct) {
                        $tsv .= join("\t", map {$_ // 0} @{$entry}{@headers}) . "\n";
                    }
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return $struct;
                }
            } else {
                if ($opts{'_get_tsv_fh'}) {
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return [];
                }
            }
        }
    );

    $app->api_http_bk;
    $app->{'api_http_bk'} = Test::MockObject::Extends->new($app->{'api_http_bk'});
    $app->api_http_bk->mock(
        'all_pages_hits_stat_day',
        sub {
            my ($api_http_bk, $from) = @_;

            if ($from eq $DATE) {
                return [
                    {
                        UpdateTime   => '2016-05-01',
                        PageID       => 43569,
                        IsDSP        => 1,
                        Hits         => 24,
                        SentHits     => 3,
                        DirectedHits => 50
                    }
                ];
            } else {
                return [];
            }
        }
    );
    $app->api_http_bk->mock(
        'get_dsp_page_stat',
        sub {
            my ($api_http_bk, %opts) = @_;

            my @headers = qw(
              Date
              PageID
              ImpID
              DSPID
              WinHits
              WinPrice
              WinPartnerPrice
              Shows
              AllHits
              WinMaxPositionsCount
              AllRealPrice
              BadWinHits
              BadWinPrice
              BadWinPartnerPrice
              BadShows
              BadAllHits
              BadWinMaxPositionsCount
              BadAllRealPrice
              );

            my $tsv = join("\t", @headers) . "\n";

            if ($opts{'starttime'} eq $DATE) {
                my $struct = [
                    {
                        Date               => '2016-05-01',
                        PageID             => 43569,
                        ImpID              => 1,
                        DSPID              => 1,
                        BadShows           => 3,
                        BadWinHits         => 5,
                        BadWinPrice        => 2043530,
                        BadWinPartnerPrice => 1675694,
                    }
                ];
                if ($opts{':return_fh'}) {
                    foreach my $entry (@$struct) {
                        $tsv .= join("\t", map {$_ // 0} @{$entry}{@headers}) . "\n";
                    }
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return $struct;
                }
            } else {
                if ($opts{':return_fh'}) {
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return [];
                }
            }
        }
    );
    $app->api_http_bk->mock(
        'get_direct_rtb_stat',
        sub {
            my ($api_http_bk, %opts) = @_;

            my @headers =
              qw(EventDate PageID ImpID PartnerStatID SumBannerShows SumBannerClicks SumBadBannerShows SumBadBannerClicks);

            my $tsv = join("\t", @headers) . "\n";

            if ($opts{'date_from'} eq $DATE) {
                my $struct = [
                    {
                        EventDate          => '2016-05-01',
                        PageID             => 43569,
                        ImpID              => 1,
                        PartnerStatID      => 0,
                        SumBannerClicks    => 12,
                        SumBannerShows     => 15,
                        SumBadBannerClicks => 2,
                        SumBadBannerShows  => 1,
                    }
                ];
                if ($opts{':return_fh'}) {
                    foreach my $entry (@$struct) {
                        $tsv .= join("\t", map {$_ // 0} @{$entry}{@headers}) . "\n";
                    }
                    $tsv = '#' . $tsv . "#END\n";
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return $struct;
                }
            } else {
                if ($opts{':return_fh'}) {
                    $tsv = '#' . $tsv . "#END\n";
                    open(my $fh, '<', \$tsv);
                    return $fh;
                } else {
                    return [];
                }
            }
        }
    );
}
