#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Differences qw(eq_or_diff);

use lib::abs qw(
  ./lib
  ../lib
  ../t_lib
  );

use Test::MockObject::Extends;
use Test::Partner2::Mock qw(mock_subs);

use qbit;

BEGIN {
    *CORE::GLOBAL::exit = sub (;$) {
        ok($_[0], 'Correctly exit status');
    };
}

use Test::Partner2::Simple;

$ENV{'TAP_VERSION'} = FALSE;

run_tests(
    sub {
        my ($app) = @_;

        $app->set_option(stage       => 'production');
        $app->set_option(cron_path   => 'path');
        $app->set_option(cron_method => 'method');

        mock_app($app);

        no strict 'refs';
        no warnings 'redefine';

        my $event;
        mock_subs(
            {
                'QBit::Cron::do' => sub {
                    throw Exception::Validation::BadArguments 'MyError';
                },
                'Partner2::Juggler::API::send' => sub {
                    my ($self, %opts) = @_;
                    $event = \%opts;
                },
            }
        );

        $app->do('path', 'method');

        eq_or_diff(
            $event,
            {
                events => [
                    {
                        description => 'MyError',
                        service     => 'cron__path__method',
                        status      => 'CRIT'
                    }
                ]
            },
            'event',
            {context => 1}
        );
    },
    application_package  => 'Cron',
    dont_create_database => TRUE,
    mocks                => {mock_send_to_graphite => FALSE, mock_juggler => FALSE},
);

sub mock_app {
    my ($app) = @_;

    $app->exception_dumper;
    $app->{'exception_dumper'} = Test::MockObject::Extends->new($app->{'exception_dumper'});
    $app->exception_dumper->mock(
        'dump_as_html_file',
        sub {
            my ($exception_dumper, $exception) = @_;

            like(
                $exception_dumper->exception2html($exception),
                qr/<html>.+?<pre\s+id="exception_text">MyError<\/pre>.+<\/html>/s,
                'Corrected dump'
            );
        }
    );
}
