use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner2::Simple;
use Test::More;

$ENV{'LAZY_LOAD'} = FALSE;

run_tests(
    sub {
        my ($app) = @_;

        my $data = from_json readfile('lib/data/direct_formats.json');

        my @accessors = grep {blessed($app->{$_}) && $app->$_->can('direct_block_types')} keys(%$app);
        foreach my $accessor (@accessors) {
            my $direct_block_types = $app->$accessor->direct_block_types();

            foreach my $block_type (@{$direct_block_types}) {
                my $id = $block_type->{id};

                next if @ARGV && $ARGV[0] ne $id;

                if ($data->{$block_type->{id}}) {

                    my $got_limit = $block_type->{banners} // $block_type->{max_banners}
                      // $block_type->{settings}->{desktop}->{banners}
                      // $block_type->{settings}->{desktop}->{max_banners};
                    my $expected_limit = $data->{$block_type->{id}}->{limit};

                    is($got_limit, $expected_limit, "$accessor $id $expected_limit");

                    my $expected_caption = $id;
                    $expected_caption =~ s/x/×/;
                    $expected_caption .= $expected_limit == 1 ? ' (1 banner)' : " (to $expected_limit banners)";

                    if ($block_type->{caption}) {
                        is($block_type->{caption}->(), $expected_caption, $accessor . ' ' . $expected_caption);
                    }
                }
            }
        }
    },
    dont_create_database => TRUE,
    do_not_die_on_fail   => TRUE,
);
