use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $cron_methods = $app->get_cron_methods();

        foreach my $path (keys %$cron_methods) {

            my %crons;
            foreach my $method (keys %{$cron_methods->{$path}}) {
                my $instances = $cron_methods->{$path}->{$method}->{attrs}->{instances};
                if ($instances) {

                    foreach my $i (1 .. $instances) {
                        $crons{$method . '_' . $i}++;
                    }
                } else {
                    $crons{$method}++;
                }
            }

            foreach my $full_method (keys %crons) {
                if ($crons{$full_method} > 1) {
                    fail("Duplicate cron definition. Path '$path' method '$full_method'.");
                }
            }

        }

    },
    application_package => 'Cron',
    do_not_die_on_fail  => 1,
);
