#!/usr/bin/perl

use strict;
use warnings FATAL   => 'all';
use Test::Most tests => 1;

my $test_name = 'no old exception names found';

my $self = $0;
$self =~ s{^\./}{};

my $count =
`ack-grep -l --perl 'ExceptionValidationError|Exception::BadArguments|Exception::Statistics::InvalidPeriod' | grep -v $self | tail -1`;

if ($count) {
    print "FILES:\n$count";
    fail($test_name);
} else {
    pass($test_name);
}
