use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

use Cpanel::JSON::XS;
use Test::Differences;
use Test::More;

BEGIN {
    $ENV{'FORM_PARTNER2_SERVER'} = 'mocked_partner2_hostname';
}

use Partner2;
use Submit;

sub partner2_create_offer {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::request'} = sub {
        my $message = <<MESSAGE;
<error>
  <msg>Bank with BIC BCITIT31228 not found in DB</msg>
  <wo-rollback>0</wo-rollback>
  <rule>Bank with BIC BCITIT31228 not found in DB</rule>
  <method>Balance2.CreateOffer</method>
  <code>CONTRACT_RULE_VIOLATION</code>
  <parent-codes>
    <code>EXCEPTION</code>
  </parent-codes>
  <contents>Bank with BIC BCITIT31228 not found in DB</contents>
</error>
MESSAGE

        my $content = encode_json(
            {
                'data'   => {'error_message' => $message,},
                'result' => 'ok',
            }
        );

        return +{
            'success' => 1,
            'url'     => $2,
            'status'  => 200,
            'content' => $content,
        };
    };

    my ($contract, $err) = Partner2::create_offer(
        'lang'             => 'en',
        'client_id'        => 3807340,
        'ctype'            => 'PARTNERS',
        'currency'         => 'RUB',
        'firm_id'          => 1,
        'nds'              => 0,
        'operator_uid'     => 242133350,
        'partner_pct'      => 43,
        'payment_type'     => 1,
        'person_id'        => 5559955,
        'service_start_dt' => '2018-05-04',
        'signed'           => 0,
        'start_dt'         => '2018-05-04',
        'test_mode'        => 1,
    );
    is($contract, undef, 'No contract');
    eq_or_diff($err, +{'swift' => 1,}, 'Error structure');
}

sub submit_submit {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'Submit::get_partner2_user_data'} = sub {
        return +{
            'db' => {
                'form_data' => {
                    'data' => encode_json(
                        {
                            'fields'   => {},
                            'language' => 'ru',
                        }
                    ),
                },
            },
        };
    };
    local *{'Branches::working_with_balance'} = sub {return undef};
    local *{'Submit::get_client_id'}          = sub {return 987654};
    local *{'Submit::create_offer'}           = sub {
        return (undef, +{'swift' => 1,});
    };
    local *{'Submit::save_data'}                = sub { };
    local *{'Submit::create_or_update_partner'} = sub { };
    local *{'Submit::send_email'}               = sub { };

    my $s = Submit->new(
        {
            'branch_id'     => 'russia_ph_part1',
            'country_id'    => 225,
            'display_login' => 'Test Login',
            'fields'        => {
                'adfox_account'                              => {'has_account' => JSON::XS::false,},
                'allow_storage_and_processing_personal_data' => JSON::XS::true,
                'cyrillic_first_name'                        => 'И',
                'cyrillic_last_name'                         => 'Ф',
                'cyrillic_patronymic_name'                   => 'О',
                'email'                                      => 'a@b.com',
                'campaign_creation'                          => undef,
                'date_of_birth'                              => '1970-01-01',
                'newsletter'                                 => JSON::XS::false,
                'oferta_agreement'                           => JSON::XS::true,
                'phone'                                      => '+79876543210',
            },
            'user_id' => 242133350,
        },
        'ru',
        'default',
        1,
    );
    my ($ok, $err) = $s->submit();
    is($ok, 0, 'Not valid submit');
    is_deeply(
        $err,
        {'swift' => [{'description' => 'Указанный SWIFT не найден',},],},
        'Error structure'
    );

}

sub main_in_test {
    plan tests => 2;

    subtest 'Check in Partner2::create_offer' => \&partner2_create_offer;
    subtest 'Check in Submit::submit'         => \&submit_submit;
}

main_in_test();
