use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Path::Tiny;
use Cpanel::JSON::XS;
use Test::More;
use Encode;

sub main_in_test {

    my %allowed_countries;

    while (<DATA>) {
        next if /^\s*#/;
        /^([0-9]+)/;
        $allowed_countries{$1}++;
    }

    foreach my $country_id (keys %allowed_countries) {
        fail("country_id '$country_id' is specified multiple times in test") if $allowed_countries{$country_id} != 1;
    }

    my $data = decode_json encode_utf8 path('./api/data/countries.json')->slurp_utf8;

    foreach my $el (@{$data}) {
        if ($allowed_countries{$el->{country_id}}) {
            ok($el->{can_work}, sprintf('country_id %s is allowed', $el->{country_id}));
        } else {
            ok(!$el->{can_work}, sprintf('country_id %s is not allowed', $el->{country_id}));
        }
    }

    done_testing();
}
main_in_test();
__DATA__
# Список из https://st.yandex-team.ru/PI-28781
210
10022
10067
10070
10088
10089
10098
10532
20274
20746
20754
20790
20856
20860
21042
21241
21278
21299
21325
21395
21426
21536
21544
21546
21556
21559
21570
21574
21578
21582
21589
21595
37176
98542
# Список из https://st.yandex-team.ru/PI-11626#1519828637000
84 — США
93 — Аргентина
94 — Бразилия
95 — Канада
96 — Германия
102 - Великобритания
113 — Австрия
114 — Бельгия
115 — Болгария
116 — Венгрия
117 — Литва
118 — Нидерланды
119 — Норвегия
120 — Польша
121 — Словакия
122 — Словения
123 — Финляндия
124 — Франция
125 — Чехия
126 — Швейцария
127 — Швеция
134 - Китай
135 — Южная Корея
137 — Япония
139 — Новая Зеландия
149 — Беларусь
159 — Казахстан
167 — Азербайджан
168 — Армения
169 — Грузия
170 — Туркменистан
171 — Узбекистан
179 — Эстония
180 — Сербия
181 — Израиль
187 — Украина
203 — Дания
204 — Испания
205 — Италия
206 — Латвия
207 — Киргизия
208 — Молдова
209 — Таджикистан
211 — Австралия
225 — Россия
246 — Греция
983 — Турция
994 — Индия
995 — Таиланд
1056 — Египет
10013 — Ямайка
10015 — Боливия
10017 — Куба
10020 — Марокко
10021 — ЮАР
10023 — Ливия
10024 — Тунис
10030 — Фиджи
10054 — Албания
10057 — Босния и Герцеговина
10064 — Исландия
10063 — Ирландия
10068 — Македония
10069 — Мальта
10074 — Португалия
10077 — Румыния
10083 — Хорватия
10090 — Афганистан
10091 — Бангладеш
10093 — Вьетнам
10095 — Индонезия
10099 — Монголия
10100 — Мьянма
10101 — Непал
10102 — Пакистан
10104 — Северная Корея
10105 — Сингапур
10108 — Филиппины
10109 — Шри-Ланка
10535 — Иордания
10536 — Иран
10537 — Кувейт
10538 — Ливан
10540 — Саудовская Аравия
10542 — Сирия
20271 — Мексика
20572 — Ирак
20574 — Кипр
20733 — Кот-д’Ивуар
20736 — Камерун
20739 — Папуа-Новая Гвинея
20741 — Нигерия
20747 — Гуам
20762 — Демократическая Республика Конго
20764 — Пуэрто-Рико
20768 — Эфиопия
20769 — Сальвадор
20785 — Эквадор
20789 — Сахарская Арабская Демократическая Республика
20802 — Гана
20818 — Гвинея
20826 — Алжир
20854 — Мадагаскар
20862 — Чили
20869 — Бенин
20915 — Соломоновы острова
20917 — Доминиканская Республика
20954 — Зимбабве
20957 — Судан
20968 — Гватемала
20972 — Лаос
20975 — Камбоджа
20989 — Эритрея
20992 — Парагвай
21004 — Мали
21007 — Центральноафриканская республика
21010 — Гамбия
21019 — Барбадос
21045 — Экваториальная Гвинея
21131 — Коста-Рика
21137 — Габон
21143 — Гвинея-Бисау
21151 — Малави
21156 — Перу
21165 — Буркина-Фасо
21171 — Того
21175 — Гондурас
21182 — Ангола
21184 — Венесуэла
21187 — Тринидад и Тобаго
21191 — Колумбия
21196 — Замбия
21198 — Республика Конго
21199 — Сан-Томе и Принсипи
21203 — Люксембург
21208 — Танзания
21214 — Бурунди
21217 — Намибия
21219 — Сьерра-Леоне
21223 — Кения
21227 — Сомали
21230 — Уганда
21231 — Никарагуа
21235 — Мозамбик
21239 — Ботсвана
21251 — Свазиленд
21261 — Лесото
21289 — Уругвай
21321 — Гаити
21326 — Кабо-Верде
21330 — Французская Полинезия
21331 — Чад
21339 — Нигер
21344 — Суринам
21349 — Мавритания
21359 — Ватикан
21371 — Руанда
21441 — Сенегал
21451 — Французская Гвиана
21475 — Джибути
21477 — Гайана
21486 — Катар
21550 — Бутан
21551 — Йемен
21553 — Американские Виргинские острова
21562 — Восточный Тимор
21567 — Гренландия
21572 — Кирибати
21580 — Федеративные Штаты Микронезии
21584 — Новая Каледония
21586 — Оман
21599 — Тонга
21601 — Тувалу
21610 — Черногория
29385 — Тайвань
29386 — Абхазия
29387 — Южная Осетия
98539 — Норфолк
98552 — Палестина
101519 — Фолклендские острова
101521 — Мартиника
108137 — Южный Судан
109724 — Синт-Мартен
