
use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Yandex::Balance;

sub main_in_test {

    no warnings 'redefine';

    *Yandex::Balance::check_bik_and_account = sub {
        my ($bik, $account) = @_;
        if ($bik eq "123123123" && $account eq "40702810638050013199") {
            return 0;
        } else {
            return 1;
        }
    };

    ok(check_account("044525225", "40702810638050013199"));
    ok(!check_account("123123123", "40702810638050013199"));

    # Единые казначейские счета (ЕКС) начиняются с нуля (#PI-23166)
    ok(check_account("123123123", "01234567890123456789"));
    ok(check_account("017501500", "03214643000000016900"));

    done_testing();
}
main_in_test();
