use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Countries;

sub main_in_test {

    my $c = Countries->new();

    my @valid = qw(
      225
      211
      210
      );
    foreach my $value (@valid) {
        ok($c->is_valid_working_country_id($value), "country_id $value is valid");
    }

    my @not_valid = qw(
      10097
      asdf
      XXX
      );
    foreach my $value (@not_valid) {
        ok(!$c->is_valid_working_country_id($value), "country_id $value is not valid");
    }

    done_testing();
}
main_in_test();
