use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More;
use FindBin;

BEGIN {
    $ENV{FORM_PARTNER2_SERVER} = 'mocked_partner2_hostname';
}

# https://st.yandex-team.ru/PI-28741#6284b15b361cf2445bf038cd

sub main_in_test {

    foreach my $file_name (glob "$FindBin::Bin/../../api/t_data/fields/*") {
        my ($field_id) = $file_name =~ /^.*\/(.*)\.json\z/;

        next if $ARGV[0] && $ARGV[0] ne $field_id;

        require "Field/${field_id}.pm";
        my $p = "Field::$field_id";
        foreach my $language (qw(ru en)) {
            my $f = $p->new(language => $language);
            if ($f->can('get_hint')) {
                my $hint = $f->get_hint();
                next unless $hint;
                ok($hint =~ /\.$/, "$field_id/$language");
            }
        }
    }

    done_testing();
}
main_in_test();
