use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More;
use FindBin;

BEGIN {
    $ENV{FORM_PARTNER2_SERVER} = 'mocked_partner2_hostname';
}

sub main_in_test {

    foreach my $file_name (glob "$FindBin::Bin/../../api/t_data/fields/*") {
        my ($field_id) = $file_name =~ /^.*\/(.*)\.json\z/;

        next if $ARGV[0] && $ARGV[0] ne $field_id;

        require "Field/${field_id}.pm";
        my $p = "Field::$field_id";
        my $f = $p->new(language => 'ru');

        is($field_id, $f->_get_id(), $field_id);
    }

    done_testing();
}
main_in_test();
