use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More;

use Utils;

sub main_in_test {

    my @yndx_logins = ('yndx-bessarabov');

    my @not_yndx_logins = (
        # нормальный, не yndx логин
        'asdf',

        # пустая строка — это пользователь с социальной авторизацией
        '',

        # такого приходить не долго — в сабу нужно всегда передавать canonical_login,
        # фиксируем в тесте такое поведение
        'yndx.bessarabov',
    );

    foreach my $login (@yndx_logins) {
        ok(is_yndx_login($login), "'$login' is yndx login");
    }

    foreach my $login (@not_yndx_logins) {
        ok(!is_yndx_login($login), "'$login' is not yndx login");
    }

    done_testing();
}
main_in_test();
