use strict;
use warnings FATAL => "all";
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::Mojo;
use Test::More tests => 4;
use Mock::Subs;
use Mojo::Util qw(monkey_patch);

use FormConstants qw( @API_TYPES_LIST );

use FindBin;
require "$FindBin::Bin/../../../../api/bin/app.psgi";

my $path = "$FindBin::Bin/../../../../api/lib/Type";    # Путь к папке типов

# Список типов, которые не передаются в API
my @not_api_types = qw(
  Base
  currency
  cyrillic_first_name
  cyrillic_last_name
  cyrillic_name
  cyrillic_patronymic_name
  organization_name
  );
my %not_api_types;
@not_api_types{@not_api_types} = ();
my %api_types;
@api_types{@API_TYPES_LIST} = ();

my $mock = Mock::Subs->new();
$mock->mock('Yandex::Blackbox::sessionid', 'return' => {'status' => {'id' => 0}, 'login' => 'BeS.teST-024'});
$mock->mock('get_form_version', return => 2);

subtest 'API call' => sub {
    plan tests => 3;

    my $tm         = Test::Mojo->new;
    my $old_listen = \&{*Mojo::Server::Daemon::listen};
    monkey_patch 'Mojo::Server::Daemon', listen => sub {
        if (ref($_[1]) eq 'ARRAY') {
            for my $i (0 .. $#{$_[1]}) {
                my $mojo_url = Mojo::URL->new($_[1]->[$i]);
                if ($mojo_url->host eq '127.0.0.1') {
                    $_[1]->[$i] = $mojo_url->host('localhost')->to_string;
                }
            }
        }
        return $old_listen->(@_);
    };
    my $old_connect = \&{*Mojo::IOLoop::Client::_connect};
    monkey_patch 'Mojo::IOLoop::Client', _connect => sub {
        if (ref($_[1]) eq 'HASH') {
            for my $key (qw(socks_address address)) {
                if (exists($_[1]->{$key}) && ($_[1]->{$key} // '') eq '127.0.0.1') {
                    $_[1]->{$key} = 'localhost';
                }
            }
        }
        return $old_connect->(@_);
    };

    # Тест на вызов API и возвращаемый список
    $tm->get_ok('/form/api/0/types')->status_is(200)->json_is('', \@API_TYPES_LIST, 'types list');
};

subtest 'API types presence' => sub {
    plan tests => scalar @API_TYPES_LIST;

    foreach my $type (@API_TYPES_LIST) {
        ok(-f (sprintf('%s/%s.pm', $path, $type)), $type);
    }
};

subtest 'types dir list' => sub {
    my $count = 0;

    # Проверка списка файлов в папке типов
    my $d;
    if (opendir($d, $path)) {
        my @types;
        while (readdir $d) {
            next if ($_ eq '.' || $_ eq '..');
            $count++;
            if (s/\.pm$//) {
                ok(exists $api_types{$_} || exists $not_api_types{$_}, $_);
            } else {
                fail('wrong dir content: ' . $_);
            }
        }
    } else {
        fail('open types dir');
    }

    done_testing($count);
};

subtest 'Lists intersection' => sub {
    plan tests => 1;

    my %all_types = (%api_types, %not_api_types);
    my $count = scalar(keys %api_types) + scalar(keys %not_api_types) - scalar(keys %all_types);
    unless (is($count, 0, 'intersection count')) {
        my %list = %all_types;
        delete @list{keys %api_types, keys %not_api_types};
        note 'rest types: ', join ', ', sort keys %list if scalar keys %list;
        my @list = grep {exists $api_types{$_}} keys %not_api_types;
        note 'both types: ', join ', ', @list if scalar @list;
    }
};
