#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::More;

use Branches;

my $br = 'ag_ph';

sub main {
    plan tests => 6;

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'Branches::get_data_from_json_file'} = sub {
            return +{
                'name_ru' => 'Физическое лицо',
                'fields'  => [
                    qw(
                      field_1
                      field_2
                      field_3
                      field_4
                      field_5
                      )
                ],
                'project_specific_fields' => {
                    'some_project_1' => {
                        'field_1' => undef,
                        'field_2' => 'new_field_2',
                        'field_3' => [
                            qw(
                              new_field_3_1
                              new_field_3_2
                              )
                        ],
                    },
                    'some_project_2' => [
                        qw(
                          new_field_1
                          new_field_2
                          new_field_3
                          new_field_4
                          new_field_5
                          )
                    ],
                },
            };
        };
    }

    my $branches = Branches->new();

    eval {
        $branches->_check_branch_id_and_get_data();
        fail('Error case: without branch');
    };
    like($@, qr/^Must specify branch_id at/, 'Error case: without branch');

    eval {
        $branches->_check_branch_id_and_get_data('qwertyuiop');
        fail('Error case: unknown branch');
    };
    like($@, qr/^Unknown branch_id qwertyuiop at/, 'Error case: unknown branch');

    # Так как метод вовзращает только 1 (или падает),
    # то дальнейшая проверка производится путём вызова get_fields,
    # так как проверяются вариации изменения поля fields в зависимости от проекта

    eq_or_diff(
        [$branches->get_fields($br)],
        [
            qw(
              field_1
              field_2
              field_3
              field_4
              field_5
              )
        ],
        'without project'
    );

    $branches = Branches->new('project' => 'some_project_1');
    eq_or_diff(
        [$branches->get_fields($br)],
        [
            qw(
              new_field_2
              new_field_3_1
              new_field_3_2
              field_4
              field_5
              )
        ],
        'project with partial replacements'
    );

    $branches = Branches->new('project' => 'some_project_2');
    eq_or_diff(
        [$branches->get_fields($br)],
        [
            qw(
              new_field_1
              new_field_2
              new_field_3
              new_field_4
              new_field_5
              )
        ],
        'project with full replacement'
    );

    $branches = Branches->new('project' => 'some_project_3');
    eq_or_diff(
        [$branches->get_fields($br)],
        [
            qw(
              field_1
              field_2
              field_3
              field_4
              field_5
              )
        ],
        'project without replacements'
    );
}

main();
