#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::Exception;
use Test::More;

use Branches;

my %TEST_DATA = (
    1 => {
        ag_ph           => 7,
        ag_ur           => 7,
        belarus_ip      => 27,
        belarus_ph      => 7,
        belarus_ur      => 27,
        russia_ip       => 1,
        russia_ph_part1 => 1,
        russia_ph_part2 => 1,
        russia_ur       => 1,
        ukraine_ph      => 7,
    },
    2 => {
        ag_ph_part1      => 7,
        ag_ph_part2      => 7,
        ag_ur_part1      => 7,
        ag_ur_part2      => 7,
        belarus_ip_part1 => 27,
        belarus_ip_part2 => 27,
        belarus_ph_part1 => 7,
        belarus_ph_part2 => 7,
        belarus_ur_part1 => 27,
        belarus_ur_part2 => 27,
        russia_ip_part1  => 1,
        russia_ip_part2  => 1,
        russia_ph_part1  => 1,
        russia_ph_part2  => 1,
        russia_ur_part1  => 1,
        russia_ur_part2  => 1,
        ukraine_ph_part1 => 7,
        ukraine_ph_part2 => 7,
    },
);

sub main_in_test {
    plan tests => scalar keys %TEST_DATA;

    foreach my $version (sort keys %TEST_DATA) {
        subtest "version $version" => sub {
            plan tests => 5 + scalar(keys %{$TEST_DATA{$version}});

            my $branches = Branches->new(version => $version);

            throws_ok {
                my $bool = $branches->get_balance_contract_firm_id();
            }
            qr/Must specify branch_id/, 'dies in case branch_id is not specified';

            throws_ok {
                my $bool = $branches->get_balance_contract_firm_id('XXX');
            }
            qr/Unknown branch_id XXX/, 'dies in case of unknown branch_id';

            eq_or_diff($branches->get_all_branches(), [sort keys %{$TEST_DATA{$version}}], 'all branches');

            foreach my $branch_id (sort keys %{$TEST_DATA{$version}}) {
                my $firm = $branches->get_balance_contract_firm_id($branch_id);
                is($firm, $TEST_DATA{$version}{$branch_id}, $branch_id);
            }

            # specific branches
            my $specific_branches = Branches->new(project => 'assessor', version => $version);
            eq_or_diff($specific_branches->get_all_branches(), ['assessor'], 'all specific branches');
            foreach my $branch_id (qw(assessor)) {
                is($specific_branches->get_balance_contract_firm_id($branch_id), 1, $branch_id);
            }
        };
    }
}
main_in_test();
