use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Branches;

sub main_in_test {

    my $branches = Branches->new();

    eval {my $bool = $branches->get_balance_person_type();};
    ok($@, 'dies in case branch_id is not specified');

    eval {my $bool = $branches->get_balance_person_type('XXX');};
    ok($@, 'dies in case of unknown branch_id');

    eval {my $bool = $branches->get_balance_person_type('assessor');};
    ok($@, 'dies in case of not working with balance');

    is($branches->get_balance_person_type('ag_ph'),           'sw_ytph', 'sw_ytph');
    is($branches->get_balance_person_type('russia_ph_part2'), 'ph',      'ph');

    done_testing();
}
main_in_test();
