use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Branches;

sub main_in_test {

    my $branches = Branches->new();

    eval {my $branch_name = $branches->get_branch_name();};
    like($@, qr/^Must specify branch_id at/, 'Must specify branch_id');

    eval {my $branch_name = $branches->get_branch_name('ag_ph');};
    like($@, qr/^Must specify language at/, 'Must specify language');

    eval {my $branch_name = $branches->get_branch_name('XXX', 'ru');};
    like($@, qr/^Unknown branch_id/, 'Unknown branch_id');

    is($branches->get_branch_name('ag_ph', 'ru'), 'Физическое лицо', 'got expected ru branch name');

    is($branches->get_branch_name('ag_ph', 'en'), 'Individual', 'got expected en branch name');

    done_testing();
}
main_in_test();
