use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Branches;

sub main_in_test {

    my $branches = Branches->new();

    eval {my $bool = $branches->get_wiki_link();};
    ok($@, 'dies in case branch_id is not specified');

    eval {my $bool = $branches->get_wiki_link('XXX');};
    ok($@, 'dies in case of unknown branch_id');

    is($branches->get_wiki_link('ag_ph'),
        'https://wiki.yandex-team.ru/partner/w/partner2-form/Anketa.Fizik.AG/', 'ag_ph');

    done_testing();
}
main_in_test();
