use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Branches;

sub main_in_test {

    my $branches = Branches->new();

    my @valid = qw(
      ag_ph
      );
    foreach my $value (@valid) {
        ok($branches->is_valid_branch_id($value), "branch_id $value is valid");
    }

    my @not_valid = qw(
      102
      asdf
      XXX
      );
    foreach my $value (@not_valid) {
        ok(!$branches->is_valid_branch_id($value), "branch_id $value is not valid");
    }

    done_testing();
}
main_in_test();
