#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::Exception;
use Test::More;

use Branches;

sub main_in_test {
    plan tests => 9;

    my $branches = Branches->new();

    throws_ok {
        my $bool = $branches->working_with_contract();
    }
    qr/Must specify branch_id/, 'dies in case branch_id is not specified';

    throws_ok {
        my $bool = $branches->working_with_contract('XXX');
    }
    qr/Unknown branch_id XXX/, 'dies in case of unknown branch_id';

    foreach my $branch_id (qw(ag_ph ag_ur russia_ip russia_ph_part1 russia_ur ukraine_ph)) {
        ok($branches->working_with_contract($branch_id), "working ($branch_id)");
    }
    foreach my $branch_id (qw(russia_ph_part2)) {
        ok(!$branches->working_with_contract($branch_id), "not working ($branch_id)");
    }
}
main_in_test();
