use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

use Cpanel::JSON::XS;
use Test::More;

BEGIN {
    $ENV{'FORM_PARTNER2_SERVER'} = 'mocked_partner2_hostname';
}

use Partner2;

my $user_id   = 607369863;
my $client_id = 9876543210;
my $error     = +{
    'id'  => -1,
    'txt' => sprintf('Passport USER_LOGIN (%d) is already linked as representative of client %d', $user_id, $client_id),
};

sub normal_client_id {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        my $content = encode_json(
            {
                'data'   => {'client_id' => $client_id,},
                'result' => 'ok',
            }
        );

        return +{
            'success' => 1,
            'url'     => $2,
            'status'  => 200,
            'content' => $content,
        };
    };

    my ($id, $err) = Partner2::get_client_id($user_id);
    is($id,  $client_id, 'Normal client_id');
    is($err, undef,      'Empty errror');
}

sub catching_error {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        my $content = encode_json(
            {
                'data'   => {'error' => $error,},
                'result' => 'ok',
            }
        );

        return +{
            'success' => 1,
            'url'     => $2,
            'status'  => 200,
            'content' => $content,
        };
    };

    my ($id, $err) = Partner2::get_client_id($user_id);
    is($id, undef, 'No client_id');
    is_deeply($err, $error, 'Errror structure');
}

sub catching_exception_status {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        return +{
            'success' => 0,
            'url'     => $2,
            'status'  => 500,
        };
    };

    my ($id, $err);
    ok(
        !eval {
            ($id, $err) = Partner2::get_client_id($user_id);
            return 1;
        },
        'Catch exception'
      );
    ok($@ =~ /^Url mocked_partner2_hostname\/intapi\/form\/client_id.json return status: 500/, 'Exception message');
}

sub catching_exception_client_id {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        return +{
            'success' => 0,
            'url'     => $2,
            'status'  => 200,
            'content' => '{}',
        };
    };

    my ($id, $err);
    ok(
        !eval {
            ($id, $err) = Partner2::get_client_id($user_id);
            return 1;
        },
        'Catch exception'
      );
    ok($@ =~ /^Can't find out client_id for user_id /, 'Exception message');
}

sub main_in_test {
    plan tests => 4;

    subtest 'Normal clien_id'           => \&normal_client_id;
    subtest 'Catching error'            => \&catching_error;
    subtest 'Catching status exception' => \&catching_exception_status;
    subtest 'Catching status exception' => \&catching_exception_client_id;
}

main_in_test();
