use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

use Cpanel::JSON::XS;
use Test::More tests => 3;

BEGIN {
    $ENV{'FORM_PARTNER2_SERVER'} = 'mocked_partner2_hostname';
}

use Partner2;

my $user_id = 607369863;

subtest 'normal version' => sub {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        my $content = encode_json(
            {
                'data'   => {'version' => 2,},
                'result' => 'ok',
            }
        );

        return +{
            'success' => 1,
            'url'     => $2,
            'status'  => 200,
            'content' => $content,
        };
    };

    my ($id, $err) = Partner2::get_form_version($user_id);
    is($id,  2,     'Normal version');
    is($err, undef, 'Empty errror');
};

subtest 'catching error, return default version' => sub {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        my $content = encode_json(
            {
                error_type => 'Exception::Validation::BadArguments',
                message    => 'test',
                result     => 'message',
            }
        );

        return +{
            'success' => 1,
            'url'     => $2,
            'status'  => 200,
            'content' => $content,
        };
    };

    my ($id, $err) = Partner2::get_form_version($user_id);
    is($id,  1,     'Default version');
    is($err, undef, 'Empty errror');
};

subtest 'catching exception status' => sub {
    plan tests => 2;

    no strict 'refs';
    no warnings 'redefine';

    local *{'HTTP::Tiny::get'} = sub {
        return +{
            'success' => 0,
            'url'     => $2,
            'status'  => 500,
        };
    };

    my ($id, $err);
    ok(
        !eval {
            ($id, $err) = Partner2::get_form_version($user_id);
            return 1;
        },
        'Catch exception'
      );
    ok($@ =~ 'Url mocked_partner2_hostname/intapi/form/form_version.json return status: 500', 'Exception message');
};
