use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Test::Exception;

BEGIN {
    $ENV{FORM_PARTNER2_SERVER} = 'mocked_partner2_hostname';
}

use Partner2;

use Data::Dumper;
use Cpanel::JSON::XS;

my %cases = (
    found_some_keys => {
        uid      => 123,
        response => {
            reason  => 'OK',
            success => 1,
            status  => 200,
            content => {
                result => 'ok',
                data   => [
                    "partner_form_123_Ha45eAYc1pN1lvXwVTZEzg_1521452273",
                    "partner_form_123_Ha45eAYc1pN1lvXwVTZEzg_1521456805",
                    "partner_form_123_Ha45eAYc1pN1lvXwVTZEzg_1521470486"
                ],
            },
        }
    },
    no_uid => {
        # no content needed. dies before http request
        uid  => undef,
        dies => 1,
    },
    empty_list => {
        uid      => 3241,
        response => {
            reason  => 'OK',
            success => 1,
            status  => 200,
            content => {
                result => 'ok',
                data   => [],
            },
        }
    },
    internal_error => {
        reason  => 'Internal Error',
        success => 0,
        status  => 500,
        content => {
            "error_type" => "Internal",
            "message"    => "Internal Error",
            "result"     => "error"
        },
        dies => 1,
    },
);

sub main_in_test {

    my $case;
    {
        no warnings 'redefine';

        *HTTP::Tiny::request = sub {
            my ($self, $method, $url, $args) = @_;

            is($method, 'GET', 'HTTP::Tiny::request method');
            is(
                $url,
                "mocked_partner2_hostname/intapi/form/list_attachments.json?lang=en&uid=$case->{uid}",
                'HTTP::Tiny::request url'
              );
            is_deeply($args, {}, 'HTTP::Tiny::request args');

            return {
                'headers' => {
                    'server'            => 'nginx',
                    'date'              => 'Mon, 26 Mar 2018 10:48:37 GMT',
                    'transfer-encoding' => 'chunked',
                    'content-type'      => 'application/json; charset=UTF-8',
                    'connection'        => 'keep-alive'
                },
                'protocol' => 'HTTP/1.1',
                'url'      => $url,
                %{$case->{response}},
                'content' => Cpanel::JSON::XS->new->utf8->canonical->encode($case->{response}{content}),
            };
        };
    }

    for my $case_name (sort keys(%cases)) {
        subtest $case_name => sub {
            $case = $cases{$case_name};
            if ($case->{dies}) {
                dies_ok {
                    list_attachments($case->{uid});
                }
                'dies';
            } else {
                lives_ok {
                    is_deeply(list_attachments($case->{uid}), $case->{response}{content}{data}, 'return value');
                }
                'lives';
            }
        };
    }

    done_testing();
}

main_in_test();
