use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Test::Exception;

BEGIN {
    $ENV{FORM_PARTNER2_SERVER} = 'mocked_partner2_hostname';
}

use Partner2;

use Data::Dumper;
use Cpanel::JSON::XS;
use Mojo::Headers;
use Mojo::Content::MultiPart;

my %cases = (
    saved_successfully => {
        uid       => 123,
        type      => 'text/plain',
        data      => 'plaintextdata',
        file_name => 'a.txt',
        response  => {
            reason  => 'OK',
            success => 1,
            status  => 200,
            content => {
                result => 'ok',
                data   => {key => 'partner_form_123_pNAez7XT7tq9nQbbrQ1q8w_1522066639',},
            },
        }
    },
    no_uid => {
        type      => 'text/plain',
        data      => 'plaintextdata',
        file_name => 'a.txt',
        dies      => 1,
    },
    no_type => {
        uid       => 123,
        data      => 'plaintextdata',
        file_name => 'a.txt',
        dies      => 1,
    },
    no_data => {
        uid       => 123,
        type      => 'text/plain',
        file_name => 'a.txt',
        dies      => 1,
    },
    no_file_name => {
        uid  => 123,
        data => 'plaintextdata',
        type => 'text/plain',
        dies => 1,
    },
    internal_error => {
        reason  => 'Internal Error',
        success => 0,
        status  => 500,
        content => {
            "error_type" => "Internal",
            "message"    => "Internal Error",
            "result"     => "error"
        },
        dies => 1,
    },
);

sub main_in_test {

    my $case;
    {
        no warnings 'redefine';

        *LWP::UserAgent::request = sub {
            my ($self, $request) = @_;

            is($request->method, 'POST', 'LWP::UserAgent::request method');
            is(
                $request->uri,
                "mocked_partner2_hostname/intapi/form/save_attachment.json",
                'LWP::UserAgent::request url'
              );
            ok($request->headers->{'content-type'} =~ /form-data/, 'LWP::UserAgent::request content-type');

            return {
                'headers' => {
                    'server'            => 'nginx',
                    'date'              => 'Mon, 26 Mar 2018 10:48:37 GMT',
                    'transfer-encoding' => 'chunked',
                    'content-type'      => 'application/json; charset=UTF-8',
                    'connection'        => 'keep-alive'
                },
                'protocol' => 'HTTP/1.1',
                'url'      => $request->uri,
                %{$case->{response}},
                'content' => Cpanel::JSON::XS->new->utf8->canonical->encode($case->{response}{content}),
            };
        };
    }

    for my $case_name (sort keys(%cases)) {
        subtest $case_name => sub {
            $case = $cases{$case_name};
            if ($case->{dies}) {
                dies_ok {
                    save_attachment($case->{uid}, $case->{type}, $case->{data}, $case->{file_name});
                }
                'dies';
            } else {
                lives_ok {
                    is_deeply(
                        save_attachment($case->{uid}, $case->{type}, $case->{data}, $case->{file_name}),
                        $case->{response}{content}{data}{key},
                        'return value'
                    );
                }
                'lives';
            }
        };
    }

    done_testing();
}

main_in_test();
