use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More;
use Test::Differences;

BEGIN {
    $ENV{'FORM_PARTNER2_SERVER'} = 'mocked_partner2_hostname';
}

use Submit;

my $common_result = {
    'longname' => 'ИП Фамилия И.О.',
    'name'     => 'Фамилия И.О.',
};
my @tests = (
    {
        'argv' => {
            'args'   => [],
            'fields' => {'organization_name' => 'Фамилия И.О.',},
        },
        'name' => 'without prefix',
    },
    {
        'argv' => {
            'args'   => [],
            'fields' => {'organization_name' => 'ИП Фамилия И.О.',},
        },
        'name' => 'with prefix',
    },
    {
        'argv' => {
            'args'   => [],
            'fields' => {'organization_name' => 'ип Фамилия И.О.',},
        },
        'name' => 'with lowcase prefix',
    },
    {
        'argv' => {
            'args'   => [],
            'fields' => {'organization_name' => " \t Фамилия И.О.\t",},
        },
        'name' => 'with spaces',
    },
    {
        'argv' => {
            'args'   => [],
            'fields' => {'organization_name' => ' иП   Фамилия И.О.',},
        },
        'name' => 'with spaces and prefix',
    },
    {
        'argv' => {
            'args'   => [],
            'fields' => {
                'organization_name' =>
                  'Индивидуальный предприниматель Фамилия И.О.',
            },
        },
        'name' => 'with long prefix',
    },
);

sub main_in_test {
    plan tests => scalar(@tests);

    for my $test (@tests) {
        eq_or_diff(
            Submit::_russia_ip_organization(%{$test->{'argv'}}),
            ($test->{'result'} || $common_result),
            $test->{'name'}
        );
    }
}

main_in_test();
