use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Clone 'clone';
use Cpanel::JSON::XS;
use File::Slurp qw(write_file);
use Test::Differences;
use Test::More;

use Branches;
use FormConstants qw(%PROJECTS);
use Submit;
use Utils;
use FindBin;

my $self_update;
my %allow;

if (@ARGV) {
    @allow{@ARGV} = (1) x @ARGV;
    $self_update = delete $allow{self_update};
}
$self_update ||= $ENV{SELF_UPDATE};

my $data_file_name = "$FindBin::Bin/../../../../api/t_data/Submit/_specific_fields_for_partner_creation.json";

my @branches = sort map {(m'.*/(.*)\.json\z')[0]} glob "$FindBin::Bin/../../../../api/data/branches/*";
my $country  = 225;
my $data     = eval {get_data_from_json_file($data_file_name)} // {};

plan tests => (scalar(keys %allow) || scalar(keys %PROJECTS) * scalar(@branches));

my $update = (keys %allow ? clone($data) : {});
foreach my $project (keys %PROJECTS) {
    my $branches = Branches->new(project => $project);
    foreach my $branch (@branches) {
        my $test_name = $project . '___' . $branch;
        next if keys %allow && !$allow{$test_name};
        if ($branches->is_valid_branch_id($branch)) {
            $update->{$test_name} =
              {Submit::_specific_fields_for_partner_creation($project, $branch, $country, $branches),};
        } else {
            $update->{$test_name} = 'invalid branch_id';
        }
        eq_or_diff($update->{$test_name}, $data->{$test_name}, $test_name);
    }
}

write_file($data_file_name, Cpanel::JSON::XS->new->utf8->allow_nonref->pretty->canonical->encode($update))
  if $self_update;
