use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More tests => 3;

BEGIN {
    $ENV{FORM_PARTNER2_SERVER} = 'mocked_partner2_hostname';
}

use Submit;

my @tests = (
    # https://www.geeksforgeeks.org/topological-sorting/
    {
        name => 'simple',
        deps => {
            5 => [],
            4 => [],
            2 => [5],
            3 => [2],
            0 => [5, 4],
            1 => [3, 4],
        },
        result => [5, 4, 0, 2, 3, 1],
    },
    # https://www.quora.com/What-problems-is-Topological-sort-useful-for/answer/Abhinav-Sharma
    {
        name => 'complex',
        deps => {
            p => [],
            m => [],
            n => [],
            o => ['p', 'n'],
            s => ['p', 'o'],
            r => ['m', 'o', 's'],
            y => ['r'],
            v => ['y', 'o'],
            x => ['v', 'm'],
            w => ['v'],
            z => ['w', 'p'],
            u => ['m', 'n'],
            q => ['m', 'n'],
            t => ['u', 'q'],
        },
        result => ['m', 'n', 'p', 'o', 'q', 's', 'r', 'u', 't', 'y', 'v', 'w', 'x', 'z'],

    },
    {
        name => 'no deps',
        deps => {
            5 => [],
            4 => [],
            2 => [],
            3 => [],
            0 => [],
            1 => [],
        },
        result => [0, 1, 2, 3, 4, 5],
    },
);

sub main_in_test {

    for my $test (@tests) {
        is_deeply(Submit::_topological_sort($test->{deps}), $test->{result}, $test->{name});
    }
}
main_in_test();
