use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::More tests => 7;
use Utils;

sub new_user {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => 'some-login',
                can_fill_part2  => '',
                language        => 'ru',
                partner2_db     => {form_data => undef, user => undef,},
                representative  => undef,
                version         => 1,
            )
        ],
        [1],
        'New user can fill form'
    );
}

sub new_yndx_user {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => 'yndx-some-login',
                can_fill_part2  => '',
                language        => 'ru',
                partner2_db     => {form_data => undef, user => undef,},
                representative  => undef,
                version         => 1,
            )
        ],
        [
            0,
            'technical_account',
'Вы вошли с помощью технического аккаунта. Пожалуйста, выберите другой логин'
        ],
        "New yndx user can't fill form"
    );
}

sub new_social_user {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => '',
                can_fill_part2  => '',
                language        => 'ru',
                partner2_db     => {form_data => undef, user => undef,},
                representative  => undef,
                version         => 1,
            )
        ],
        [
            0,
            'need_postregistration',
'Вы вошли с помощью аккаунта в социальной сети. Для работы с Рекламной сетью необходимо завести логин и пароль <https://passport.yandex.ru/passport?mode=postregistration&create_login=1>'
        ],
        "New social user wihtout login can't fill form"
    );
}

sub existing_user {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => 'some-login',
                can_fill_part2  => '',
                language        => 'ru',
                partner2_db     => {form_data => undef, user => {},},
                representative  => undef,
                version         => 1,
            )
        ],
        [-1, 'registered', 'Вы уже были зарегистрированы'],
        "Existing user can't fill form"
    );
}

sub existing_yndx_user {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => 'yndx-some-login',
                can_fill_part2  => '',
                language        => 'ru',
                partner2_db     => {form_data => undef, user => {},},
                representative  => undef,
                version         => 1,
            )
        ],
        [
            0,
            'technical_account',
'Вы вошли с помощью технического аккаунта. Пожалуйста, выберите другой логин'
        ],
        "Existing yndx user can't fill form"
    );
}

sub existing_user_that_can_fill_part2 {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => 'some-login',
                can_fill_part2  => 1,
                language        => 'ru',
                partner2_db     => {form_data => undef, user => {},},
                representative  => undef,
                version         => 1,
            )
        ],
        [1],
        'Existing user that can fill part2 can fill form'
    );
}

sub new_user_with_representative {
    eq_or_diff(
        [
            can_fill_form(
                canonical_login => 'some-login',
                can_fill_part2  => '',
                language        => 'ru',
                partner2_db     => {form_data => undef, user => undef,},
                representative  => 607369863,
                version         => 1,
            )
        ],
        [
            0,
            'representative',
'Вы являетесь представителем другого аккаунта, который уже был зарегистрирован'
        ],
        "New user with representative can't fill form"
    );
}

sub main_in_test {
    new_user();
    new_yndx_user();
    new_social_user();
    existing_user();
    existing_yndx_user();
    existing_user_that_can_fill_part2();
    new_user_with_representative();
}
main_in_test();
