use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::More tests => 9;
use Test::Differences;

use FormConstants qw(%PROJECTS);
use Utils qw(is_valid_project);

sub projects_count {
    is(scalar(keys %PROJECTS), 6, 'Projects count');
}

sub not_defined_project {
    is(is_valid_project(), '', 'Previous usual form should be "default"');
}

sub unknown_project {
    is(is_valid_project('unknown'), '', 'Unknow project form');
}

sub default_project {
    is(is_valid_project('default'), 1, 'Default project (like not defined)');
}

sub games {
    is(is_valid_project('games'), 1, 'Games form');
}

sub mobile_mediation {
    is(is_valid_project('mobile_mediation'), 1, 'Mobile mediation form');
}

sub video_blogger {
    is(is_valid_project('video_blogger'), 1, 'Video blogger form');
}

sub efir_blogger {
    is(is_valid_project('efir_blogger'), 1, 'Video blogger form');
}

sub assessor {
    is(is_valid_project('assessor'), 1, 'Assessor form');
}

sub main_in_test {
    projects_count();
    not_defined_project();
    unknown_project();
    default_project();
    games();
    mobile_mediation();
    video_blogger();
    efir_blogger();
    assessor();
}
main_in_test();
