use strict;
use warnings FATAL => "all";
use utf8;
use open qw(:std :utf8);

#use Test::Differences;
use Test::More;
use Utils;

my %tests;

sub main {
    plan tests => 2;

    subtest 'check input data' => sub {
        my $data = get_data_from_json_file './api/t_data/Utils/normalize_cyrillic_names.json';

        plan tests => 1 + 3 * scalar(@$data);

        ok(scalar(@$data) > 0, 'not empty');
        foreach my $name (@$data) {
            utf8::decode($name) unless utf8::is_utf8($name);
            like($name, qr/^[а-яё]+(?:[' -][а-яё]+)*$/i, sprintf(q[correct name (%s)], $name));
            $tests{$name} = $name;
            my $lcname = lc $name;
            like($lcname, qr/^[а-яё' -]+$/, sprintf(q[correct lc name (%s)], $name));
            $tests{$lcname} = $name;
            my $ucname = uc $name;
            like($ucname, qr/^[А-ЯЁ' -]+$/, sprintf(q[correct uc name (%s)], $name));
            $tests{$ucname} = $name;

            if ($name =~ /'/) {
                my $qqname = $name;
                $qqname =~ s/'/"/g;
                $tests{$qqname} = $name;
                my $bqname = $name;
                $bqname =~ s/'/`/g;
                $tests{$bqname} = $name;
            }
        }
    };

    subtest 'main check' => sub {
        plan tests => scalar keys %tests;

        foreach my $name (sort keys %tests) {
            is(normalize_cyrillic_names($name), $tests{$name}, sprintf(q[change "%s" => "%s"], $name, $tests{$name}));
        }
    };
}

main();
