package TestFilters;

use Utils;

sub MODIFY_CODE_ATTRIBUTES {
    my ($package, $sub, @attrs) = @_;

    return Utils::setup_sensitive_data_filters($package, $sub, @attrs);
}

sub array_positions : SENSITIVE_DATA_ARRAY_POSITIONS(0, 2) {
    die
}

sub array_pointers : SENSITIVE_DATA_ARRAY_POINTERS('/0/key0', '/2') {
    die
}

sub hash_keys : SENSITIVE_DATA_HASH_KEYS('key1', 'key2', 'key3') {
    die
}

sub hash_pointers : SENSITIVE_DATA_HASH_POINTERS('/key1/key2', '/key3') {
    die
}

sub filter_with_sub : SENSITIVE_DATA_FILTER_WITH_SUB('TestFilters::filter_args') {
    die
}

sub filter_all : SENSITIVE_DATA_FILTER_ALL() {
    die
}

sub filter_args {
    my (%sub_args) = @_;
    $sub_args{key1}{key2} = 'changed_inner_value';
    delete $sub_args{key3};
    $sub_args{key5} = 'new_value';
    return %sub_args;
}

1;

package main;
use strict;
use warnings FATAL => "all";
use utf8;
use open qw(:std :utf8);

use Test::More tests => 12;
use Test::Mojo;
use Mock::Subs;
use Mojo::Util qw(monkey_patch);
use FindBin;
use Utils;

require "$FindBin::Bin/../../../../api/bin/app.psgi";

my @tests = (
    {
        sub      => 'array_positions',
        args     => [0, 1, 2, 3, 4],
        expected => ['FILTERED', 1, 'FILTERED', 3, 4],
    },
    {
        sub      => 'array_pointers',
        args     => [{key0 => 'value'}, 1],
        expected => [{key0 => 'FILTERED'}, 1],
    },
    {
        sub  => 'hash_keys',
        args => [
            key1 => 'value1',
            key3 => {inner_key => 'inner_value'},
            key4 => 'value4',
        ],
        expected => {
            key1 => 'FILTERED',
            key3 => 'FILTERED',
            key4 => 'value4',
        },
    },
    {
        sub  => 'hash_pointers',
        args => [
            key1 => {key2 => 'inner_value'},
            key3 => 'value1',
            key4 => 'value4',
        ],
        expected => {
            key1 => {key2 => 'FILTERED'},
            key3 => 'FILTERED',
            key4 => 'value4',
        },
    },
    {
        sub  => 'filter_with_sub',
        args => [
            key1 => {key2 => 'inner_value'},
            key3 => 'value1',
            key4 => 'value4',
        ],
        expected => {
            key1 => {key2 => 'changed_inner_value'},
            key4 => 'value4',
            key5 => 'new_value',
        },
    },
    {
        sub  => 'filter_all',
        args => [
            key1 => {key2 => 'inner_value'},
            key3 => 'value1',
            key4 => 'value4',
        ],
        expected => ['FILTERED_ALL_ARGS'],
    },
);

sub main {
    no strict 'refs';
    my $e;
    {
        no warnings 'redefine';
        *main::send_to_sentry = sub {
            my (%opts) = @_;
            $e = $opts{exception};
        };
        no warnings 'once';
        *main::get_form_version = sub {2};
    }

    my $mock = Mock::Subs->new();
    $mock->mock('Yandex::Blackbox::sessionid', 'return' => {'status' => {'id' => 0}, 'login' => 'BeS.teST-024'});

    my $t          = Test::Mojo->new;
    my $old_listen = \&{*Mojo::Server::Daemon::listen};
    monkey_patch 'Mojo::Server::Daemon', listen => sub {
        if (ref($_[1]) eq 'ARRAY') {
            for my $i (0 .. $#{$_[1]}) {
                my $mojo_url = Mojo::URL->new($_[1]->[$i]);
                if ($mojo_url->host eq '127.0.0.1') {
                    $_[1]->[$i] = $mojo_url->host('localhost')->to_string;
                }
            }
        }
        return $old_listen->(@_);
    };
    my $old_connect = \&{*Mojo::IOLoop::Client::_connect};
    monkey_patch 'Mojo::IOLoop::Client', _connect => sub {
        if (ref($_[1]) eq 'HASH') {
            for my $key (qw(socks_address address)) {
                if (exists($_[1]->{$key}) && ($_[1]->{$key} // '') eq '127.0.0.1') {
                    $_[1]->{$key} = 'localhost';
                }
            }
        }
        return $old_connect->(@_);
    };

    for my $test (@tests) {
        my ($sub, $args, $expected) = @$test{qw(sub args expected)};
        $t->app->routes->get("/$sub" => sub {&{"TestFilters::$sub"}(@$args)});
        my $tx = $t->ua->build_tx(GET => "/$sub" => {} => 'json');
        $t->request_ok($tx);
        if (ref($expected) eq 'HASH') {
            is_deeply($expected, {@{$e->frames->[1][-1]}}, 'expected filtered args');
        } else {
            is_deeply($expected, $e->frames->[1][-1], 'expected filtered args');
        }
    }
}

main();
