use strict;
use warnings FATAL => "all";
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::Exception;
use Test::More tests => 7;

use FormConstants qw(
  $TVM_SOLOMON_ID
  );
use Yandex::TVM qw(get_x_ya_service_ticket);

throws_ok {
    get_x_ya_service_ticket();
}
qr/Can't find out TVM destination ID/, 'incorrect usage (without dst)';

throws_ok {
    get_x_ya_service_ticket('unknown');
}
qr/Unknown TVM service 'unknown'/, 'incorrect usage (with unknown dst)';

$ENV{FORM_STAGE} = 'dev';
is(get_x_ya_service_ticket($TVM_SOLOMON_ID), 'dev', 'check dev ticket');

$ENV{FORM_STAGE}              = 'test';
$ENV{TVMTOOL_LOCAL_AUTHTOKEN} = 'mocked_tvmtool_local_authtoken';
{
    no strict 'refs';
    no warnings 'redefine';
    *HTTP::Tiny::request = sub {
        my ($self, @opts) = @_;

        eq_or_diff(
            \@opts,
            [
                'GET',
                $ENV{'DEPLOY_TVM_TOOL_URL'} . '/tvm/tickets?dsts=2010242&src=2000661',
                {headers => {Authorization => 'mocked_tvmtool_local_authtoken'},},
            ],
            'resuest to tvm demon'
        );

        return {content => '{}',};
    };
}
throws_ok {
    get_x_ya_service_ticket($TVM_SOLOMON_ID);
}
qr/Can't find out 'X-Ya-Service-Ticket'/, 'incorrect ticket';

{
    no strict 'refs';
    no warnings 'redefine';
    *HTTP::Tiny::request = sub {
        return {content => '{"solomon" : {"ticket" : "mocked_tvm_service_ticket", "tvm_id" : 2010242}}',};
    };
}
is(get_x_ya_service_ticket($TVM_SOLOMON_ID), 'mocked_tvm_service_ticket', 'check ticket');

{
    no strict 'refs';
    no warnings 'redefine';
    *HTTP::Tiny::request = sub {
        fail 'check cache';
    };
}
is(get_x_ya_service_ticket($TVM_SOLOMON_ID), 'mocked_tvm_service_ticket', 'check cache');

done_testing();
