use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use Test::Differences;
use Test::More;
use Submit;

sub main_in_test {

    eq_or_diff([Submit->new({}, 'ru')->submit(),], [0, {global => [{description => 'Incorrect data structure',}],},]);

    eq_or_diff(
        [
            Submit->new(
                {
                    user_id       => 123,
                    display_login => 'Test Login',
                    country_id    => 123,
                    branch_id     => 'asdf',
                    fields        => {},
                },
                'ru',
              )->submit(),
        ],
        [0, {global => [{description => 'Unknown branch_id',}],},]
    );

    eq_or_diff(
        [
            Submit->new(
                {
                    user_id       => 123,
                    display_login => 'Test Login',
                    country_id    => 96,
                    branch_id     => 'ag_ph',
                    fields        => {
                        email                                      => 'devnull@yandex.ru',
                        iban_or_account                            => {iban => 'GB29NWBK60161331926819',},
                        latin_lastname                             => 'Ivanov',
                        latin_name                                 => 'Ivan',
                        latin_freeform_address                     => '',
                        gender                                     => 'M',
                        date_of_birth                              => '2000-01-01',
                        phone                                      => 'asdf',
                        currency                                   => 'USD',
                        account_owner                              => 'IVANOV IVAN',
                        latin_bank_name                            => 'SBERBANK',
                        newsletter                                 => JSON::XS::true,
                        oferta_agreement                           => JSON::XS::true,
                        allow_storage_and_processing_personal_data => JSON::XS::true,
                        campaign_creation                          => undef,
                        gdpr_warning                               => undef,
                    },
                },
                'ru',
              )->submit(),
        ],
        [
            0,
            {
                zip_code               => [{description => 'Поле должно быть заполнено',},],
                swift                  => [{description => 'Поле должно быть заполнено',},],
                phone                  => [{description => 'Неверное значение',},],
                latin_city             => [{description => 'Поле должно быть заполнено',},],
                latin_freeform_address => [{description => 'Неверное значение',},],
                ag_ph_scan             => [{description => 'Поле должно быть заполнено',},],
                adfox_account          => [{description => 'Поле должно быть заполнено',},],
                gender                 => [{description => 'Это поле лишнее',},],
                gdpr_warning           => [{description => 'Это поле лишнее',},],
                global => [{description => 'Указаны лишние поля: gdpr_warning, gender'},]
            },
        ]
    );

    done_testing();
}
main_in_test();
