#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Most;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        is_deeply(
            $app->context_on_site_campaign->get_block_model_names(),
            [
                'context_on_site_content', 'context_on_site_direct',
                'context_on_site_rtb',     'context_on_site_stripe',
                'context_on_site_adblock', 'context_on_site_natural',
            ]
        );

        is_deeply(
            $app->search_on_site_campaign->get_block_model_names(),
            ['search_on_site_premium', 'search_on_site_direct',]
        );

        is_deeply($app->video_an_site->get_block_model_names(),
            ['video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen']);

        is_deeply($app->mobile_app_settings->get_block_model_names(), ['mobile_app_rtb',]);

        is_deeply(
            $app->internal_context_on_site_campaign->get_block_model_names(),
            [
                'internal_context_on_site_direct', 'internal_context_on_site_rtb',
                'internal_context_on_site_stripe', 'internal_context_on_site_content',
                'internal_context_on_site_natural'
            ]
        );

        is_deeply(
            $app->internal_search_on_site_campaign->get_block_model_names(),
            ['internal_search_on_site_premium', 'internal_search_on_site_direct',]
        );

        is_deeply($app->internal_mobile_app->get_block_model_names(), ['internal_mobile_app_rtb',]);

        is_deeply($app->ssp_context_on_site_campaign->get_block_model_names(), ['ssp_context_on_site_rtb',]);

        is_deeply($app->ssp_mobile_app_settings->get_block_model_names(), ['ssp_mobile_app_rtb',]);

        is_deeply($app->ssp_video_an_site->get_block_model_names(), ['ssp_video_an_site_rtb',]);

        is_deeply($app->indoor->get_block_model_names(), ['indoor_block',]);

        is_deeply($app->outdoor->get_block_model_names(), ['outdoor_block',]);

        my @all_block_model_names = @{$app->product_manager->get_block_model_names()};

        cmp_deeply(
            \@all_block_model_names,
            bag(
                qw(
                  context_on_site_adblock
                  context_on_site_content
                  context_on_site_direct
                  context_on_site_rtb
                  context_on_site_stripe
                  context_on_site_natural
                  indoor_block
                  internal_context_on_site_direct
                  internal_context_on_site_rtb
                  internal_context_on_site_stripe
                  internal_context_on_site_content
                  internal_context_on_site_natural
                  internal_mobile_app_rtb
                  internal_search_on_site_direct
                  internal_search_on_site_premium
                  mobile_app_rtb
                  outdoor_block
                  search_on_site_direct
                  search_on_site_premium
                  video_an_site_inpage
                  video_an_site_instream
                  video_an_site_fullscreen
                  ssp_mobile_app_rtb
                  ssp_context_on_site_rtb
                  ssp_video_an_site_rtb
                  )
               ),
        );

    }
);
