#!/usr/bin/perl -w

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my @models = $app->context_on_site_campaign->get_block_models();

        my @refs = map {ref $_} @models;

        is_deeply(
            \@refs,
            [
                "Application::Model::Product::AN::ContextOnSite::Content",
                "Application::Model::Product::AN::ContextOnSite::Direct",
                "Application::Model::Product::AN::ContextOnSite::RTB",
                "Application::Model::Product::AN::ContextOnSite::Stripe",
                "Application::Model::Product::AN::ContextOnSite::AdBlock",
                "Application::Model::Product::AN::ContextOnSite::Natural",
            ]
        );

    },
    dont_create_database => 1
);
