use lib::abs qw(
  ../lib
  );
use qbit;
use Test::More;
use Test::Exception;

sub check_correct_urls {
    my $tests = [
        {
            url      => 'example.com',
            expected => 'example.com',
        },
        {
            url      => 'www.example.com',
            expected => 'example.com',
        },
        {
            url      => 'www.example.com/test',
            expected => 'example.com',
        },
        {
            url      => 'http://www.example.com/test',
            expected => 'example.com',
        },
        {
            url      => 'https://www.example.com/test',
            expected => 'example.com',
        },
        {
            url      => 'http://www.example.com/test',
            opts     => {www => TRUE},
            expected => 'www.example.com',
        },
        {
            url      => 'http://www.example.com:2134/test',
            opts     => {www => TRUE, with_port => TRUE},
            expected => 'www.example.com:2134',
        },
        {
            url      => 'http://example2.com:2134/test',
            opts     => {www => TRUE, with_port => FALSE},
            expected => 'example2.com',
        },
        {
            url      => 'example.com',
            opts     => {www => TRUE},
            expected => 'example.com',
        },
        {
            url      => 'https://кириллица.рф',
            expected => 'кириллица.рф',
        },
        {
            url      => 'http://кириллица.рф',
            opts     => {ascii => TRUE},
            expected => 'xn--80apaahia1b8c.xn--p1ai',
        },
        {
            url      => '0',
            expected => '0',
        },
    ];

    foreach my $test (@$tests) {
        my $test_name = sprintf("('%s'%s) => %s",
            $test->{'url'}, defined($test->{opts}) ? ', ' . join(' => ', %{$test->{opts}}) : '',
            $test->{'expected'},);

        is(get_domain($test->{'url'}, %{$test->{opts}}), $test->{'expected'}, 'get_domain' . $test_name);
        is(get_domain_or_throw($test->{'url'}, %{$test->{opts}}),
            $test->{'expected'}, 'get_domain_or_throw' . $test_name);
    }
}

sub check_incorrect_urls {
    my @urls = ('//', '(', {}, [],);

    foreach my $url (@urls) {

        is(get_domain($url), undef, "get_domain('$url') => undef",);

        eval {get_domain_or_throw($url),};
        is(
            ref($@),
            'Exception::Validation::BadArguments',
            "get_domain_or_throw('$url') throws Exception::Validation::BadArguments",
          );
    }

}

sub main_in_test {

    pass('Loaded ok');

    check_correct_urls();
    check_incorrect_urls();

    done_testing();
}
main_in_test();
