use lib::abs qw(
  ../lib
  );
use qbit;
use Test::More;
use Test::Exception;

use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_test_data_and_update_if_needed);

my $test_opts = {
    widget       => {widget    => TRUE, www       => TRUE},
    www          => {www       => TRUE},
    www_and_port => {www       => TRUE, with_port => TRUE},
    port         => {with_port => TRUE},
    ascii        => {ascii     => TRUE}
};
my $test_urls = [
    'example.com',                      'www.example.com',
    'www.example.com/test',             'http://www.example.com/test',
    'https://www.example.com/test',     'http://www.example.com/test',
    'http://www.example.com:2134/test', 'http://example2.com:2134/test',
    'https://кириллица.рф',  '0',
    '//.com',                           '(.ru',
    'doma,in.com',                      'doma|n.com',
];

sub main_in_test {

    pass('Loaded ok');

    my %test_data;
    foreach my $test (@$test_urls) {
        foreach my $opts (keys %$test_opts) {

            $test_data{$test}{$opts} = get_domain_or_error($test, %{$test_opts->{$opts}});
        }
    }
    my $has_data = get_test_data_and_update_if_needed('data.json', \%test_data);
    eq_or_diff(from_json(to_json(\%test_data)), $has_data, 'checks');

    done_testing();
}
main_in_test();
