use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Exception;

use qbit;

sub check_normalization {
    my @tests = (
        ['123'                  => '123'],
        [' 123'                 => '123'],
        ['123 '                 => '123'],
        [' 123 '                => '123'],
        ['   123  '             => '123'],
        ['+791512345678'        => '+791512345678'],
        ['+7 495 739-70-00'     => '+7 495 739-70-00'],
        ['+7 495 739 - 70 - 00' => '+7 495 739-70-00'],

        # Кажется, это нужно будет поправить (думаю что нужно схлопывать больше чем один пробел в один пробел)
        ['1  23' => '1  23'],

        # Не понятно зачем такая логика
        ['+ 7  ( 915 ) 12345678' => '+ 7 ( 915 ) 12345678'],
    );

    foreach my $element (@tests) {
        is(get_normalized_phone_or_throw($element->[0]),
            $element->[1], sprintf("'%s' => '%s'", $element->[0], $element->[1]));
    }
}

sub check_incorrect_phones {
    my @phones = ('abc', '123 добавочный 17',);

    foreach my $phone (@phones) {

        throws_ok {
            get_normalized_phone_or_throw($phone);
        }
        qr/.*/, "phone '%s' throws exeption";
    }
}

sub check_undef_phone {
    my $phone = undef;

    my $regexp = gettext("Phone is not defined");

    throws_ok {
        get_normalized_phone_or_throw($phone);
    }
    qr/$regexp/, "undef phone throws exeption";
}

sub main_in_test {

    pass('Loaded ok');

    check_normalization();
    check_incorrect_phones();
    check_undef_phone();

    done_testing();

}
main_in_test();
