#!/usr/bin/perl -w

use qbit;

use Test::More;
use Business::IBAN;
use Business::SWIFT;

my $iban = Business::IBAN->new();
is(scalar($iban->valid('LT254010042900462310')),  1,     'Valid');
is(scalar($iban->valid('LT100006058018')),        undef, 'Invalid');
is(scalar($iban->valid('LV59HABA0551009081841')), 1,     'Valid');
is(scalar($iban->valid('LV59HABA0551009081842')), undef, 'Invalid');
is(scalar($iban->valid('EE812200221024261882')),  1,     'Valid');
is(scalar($iban->valid('EE812200221024265882')),  undef, 'Invalid');

is(scalar(Business::SWIFT->validateBIC('DEUTDEFF')),  1, 'Valid SWIFT');
is(scalar(Business::SWIFT->validateBIC('AGBLLT2X')),  1, 'Valid SWIFT');
is(scalar(Business::SWIFT->validateBIC('AGBLLT2X1')), 0, 'Invalid SWIFT');
is(scalar(Business::SWIFT->validateBIC('AGBLLT2')),   0, 'Invalid SWIFT');

done_testing();
