#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner2::Mock;

use Test::Partner::Utils qw(request_to_api get_test_data_and_update_if_needed);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2021-07-23 10:00:00');
        mock_selfcheck();
        my $log = '';
        mock_subs(
            {
                'Application::Model::CheckAlive::INFO' => sub {
                    my ($msg) = @_;
                    $log .= "INFO: $msg\n";
                },
                'Application::Model::CheckAlive::ERROR' => sub {
                    my ($msg) = @_;
                    $log .= "ERROR: $msg\n";
                },
            }
        );

        my @got = request_to_api(
            app    => $app,
            path   => 'check',
            method => 'readiness_probe',
            ext    => 'json',
        );
        push @got, $log;

        my $got = join "\n" . ("-" x 30) . "\n", @got;
        my $has = get_test_data_and_update_if_needed('data.dump', $got, raw => 1);
        eq_or_diff($got, $has);
    },
    application_package => 'API',
    init                => ['check_alive'],
);
