#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils;
use Test::More;
use Test::Differences qw(eq_or_diff);
use Test::Partner::Utils qw(get_hash_from_http_message);
use PiConstants qw($IS_PRECISE);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $actual;
        my $expected;

        mock_mol(
            $app,
            {
                "data"            => [[888888888,]],
                "duration"        => 1.344,
                "error_text"      => "",
                "header"          => ["Price",],
                "host-aggregator" => "localhost",
                "stat_time"       => 0,
                "status"          => 0,
                "total_rows"      => 10,
                "totals"          => {"Price" => 999999999,}
            }
        );
        my ($ok_main, undef, undef) = request_to_api(
            app          => $app,
            path         => 'statistics2',
            method       => 'get',
            ext          => 'json',
            query_string => 'lang=C&oauth_token=mocked-yan-partner'
              . '&period=2020-09-10&period=2020-09-10'
              . '&field=all_wo_nds'
        );
        $actual = get_hash_from_http_message($ok_main);
        $expected = get_test_data_and_update_if_needed("ok_main.json", $actual);
        eq_or_diff($actual, $expected);

        my ($fail_mm, undef, undef) = request_to_api(
            app          => $app,
            path         => 'statistics2',
            method       => 'get',
            ext          => 'json',
            query_string => 'lang=C&oauth_token=mocked-yan-partner'
              . '&period=2020-09-10&period=2020-09-10'
              . '&field=all_wo_nds'
              . '&stat_type=mm'
        );
        $actual = get_hash_from_http_message($fail_mm);
        $expected = get_test_data_and_update_if_needed("fail_mm.json", $actual);
        eq_or_diff($actual, $expected);

        mock_mol(
            $app,
            {
                "data"            => [[960511,]],
                "duration"        => 1.344,
                "error_text"      => "",
                "header"          => ["HitsMM",],
                "host-aggregator" => "localhost",
                "stat_time"       => 0,
                "status"          => 0,
                "total_rows"      => 10,
                "totals"          => {"HitsMM" => "960511",}
            }
        );
        my ($ok_mm, undef, undef) = request_to_api(
            app          => $app,
            path         => 'statistics2',
            method       => 'get',
            ext          => 'json',
            query_string => 'lang=C&oauth_token=mocked-yan-partner'
              . '&period=2020-09-10&period=2020-09-10'
              . '&field=hits_mm'
              . '&stat_type=mm'
        );

        $actual = get_hash_from_http_message($ok_mm);
        $expected = get_test_data_and_update_if_needed("ok_mm.json", $actual);
        eq_or_diff($actual, $expected);
    },
    application_package => 'API',
);
