#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_subs);
use Test::More;
use Test::Differences qw(eq_or_diff);

use Test::Partner::Utils qw(request_to_api get_test_data_and_update_if_needed eq_or_diff_http_message);

use qbit;

my $MOCKED_BK_ANSWER = q({
   "data" : {
      "currencies" : [
         {
            "code" : "USD",
            "id" : "1"
         },
         {
            "code" : "RUB",
            "id" : "2"
         },
         {
            "code" : "EUR",
            "id" : "3"
         }
      ],
      "dimensions" : {
         "domain" : {
            "index" : 1,
            "title" : "Домен или Bundle ID",
            "type" : "categories"
         },
         "page_id" : {
            "index" : 2,
            "title" : "Page ID",
            "type" : "page_id"
         }
      },
      "is_last_page" : true,
      "measures" : {
         "rtb_block_all_hits" : {
            "index" : 3,
            "title" : "Запросы рекламы в блоках",
            "type" : "number",
            "unit" : "count"
         },
         "rtb_block_direct_shows" : {
            "index" : 4,
            "title" : "Показы Директа в RTB-блоках",
            "type" : "number",
            "unit" : "count"
         }
      },
      "periods" : [
         [
            "2020-09-10",
            "2020-09-10"
         ]
      ],
      "points" : [
         {
            "dimensions" : {
               "domain" : "kinopoisk.ru",
               "page_id" : 53100
            },
            "measures" : [
               {
                  "rtb_block_all_hits" : 124980,
                  "rtb_block_direct_shows" : 44
               }
            ]
         }
      ],
      "report_title" : "Отчет за период 10.09.2020 - 10.09.2020",
      "totals" : {
         "2" : [
            {
               "rtb_block_all_hits" : 124980,
               "rtb_block_direct_shows" : 44
            }
         ]
      }
   },
   "result" : "ok"
});

run_tests(
    sub {
        my ($app) = @_;

        $app->bk_statistics;
        mock_subs(
            {
                'Application::Model::BKStatistics::get_statistics2' => sub {
                    my ($self, %opts) = @_;
                    return from_json($MOCKED_BK_ANSWER)->{data};
                  }
            }
        );

        my @got = request_to_api(
            app          => $app,
            path         => 'statistics2',
            method       => 'get',
            ext          => 'xml',
            query_string => 'lang=C&oauth_token=mocked-yan-partner&pretty=1'
              . '&period=2020-09-10&period=2020-09-10'
              . '&level=[{"id":"advnet_context_on_site"}]'
              . '&field=rtb_block_direct_shows&field=rtb_block_all_hits'
              . '&limits={"limit":50,"offset":0}'
              . '&dimension_field=date|day'
              . '&entity_field=page_id&entity_field=domain'
              . '&filter=["AND",[["page_id","=","53100"]]]'
              . '&order_by=[{"field":"date","dir":"asc"}]',
        );

        my $got = join "\n" . ("-" x 30) . "\n", @got;
        my $has = get_test_data_and_update_if_needed('data.dump', $got, raw => 1);
        eq_or_diff_http_message($got, $has, 'check results', {context => 10});

    },
    application_package => 'API',
);
